package org.seasar.eclipse;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public final class SeasarProjectDeleteChangeListener implements IResourceChangeListener {

	private static final String TITLE = SeasarPlugin.getResourceString("delete.title");
	private static final String DESCRIPTION = SeasarPlugin.getResourceString("delete.description");
    private static final String FAIL_MESSAGE = SeasarPlugin.getResourceString("delete.fail.message");
	
	public void resourceChanged(IResourceChangeEvent event) {
		if (event.getResource() instanceof IProject) {
			try {
				SeasarProject seasarProject = SeasarProject.getSeasarProject(
					(IProject) event.getResource());
                if (seasarProject != null) {
                    Display.getDefault().syncExec(new DeleteRunnable(seasarProject));
                }
			} catch (CoreException ex) {
				SeasarPlugin.handleException(ex);
			}
				
		}
	}
	
	private class DeleteRunnable implements Runnable {
		
		private SeasarProject _seasarProject;
		
		DeleteRunnable(SeasarProject seasarProject) {
			_seasarProject = seasarProject;
		}
		
		public void run() {
			IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

			String[] labels = {IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
			MessageDialog dialog = new MessageDialog(
				window.getShell(),
				TITLE,
				null,
				DESCRIPTION,
				MessageDialog.QUESTION,
				labels,
				1);
		
			if (dialog.open() == MessageDialog.OK ) {
				try {
					_seasarProject.removeWebApplicationInJettyXML();
				} catch (Exception ex) {
					SeasarPlugin.handleException(ex, TITLE, FAIL_MESSAGE);
				}		
			}
		}
	}

}
