/*
class test.seasar.unit.TestResultTest extends seasar.unit.TestCase
*/
if (test.seasar.unit.TestResultTest == null) {
	#include "seasar/lang/SObject.as"
	#include "seasar/unit/TestCase.as"
	#include "seasar/unit/TestFailure.as"
	#include "seasar/unit/TestResult.as"
	
	seasar.lang.SObject.defineClass("test.seasar.unit.TestResultTest", seasar.unit.TestCase, ["result"]);
		
	var proto = test.seasar.unit.TestResultTest.prototype;
	
	proto.setUp = function() {
		this.result = new seasar.unit.TestResult();
	}
	
	proto.tearDown = function() {
		this.result = null;
	}
	
	proto.testAddFailure = function() {
		var failure = new seasar.unit.TestFailure("Foo", "testAaa", "fail");
		this.result.addFailure(failure);
		this.assertEquals(1, this.result.testCount);
		this.assertEquals(1, this.result.failureCount);
		this.assertEquals(0, this.result.successCount);
	}
	
	proto.testGetFailure = function() {
		var failure = new seasar.unit.TestFailure("Foo", "testAaa", "fail");
		this.result.addFailure(failure);
		this.assertEquals(failure, this.result.getFailure(0));
	}
	
	proto.testAddSuccess = function() {
		this.result.addSuccess();
		this.assertEquals(1, this.result.testCount);
		this.assertEquals(0, this.result.failureCount);
		this.assertEquals(1, this.result.successCount);
	}

	delete proto;
}