/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.compiler.parser;

import java.lang.reflect.Array;
import org.codehaus.backport175.compiler.SourceLocation;
import org.codehaus.backport175.compiler.javadoc.RawAnnotation;
import org.codehaus.backport175.compiler.parser.AnnotationValidationException;
import org.codehaus.backport175.compiler.parser.AnnotationValidator;
import org.codehaus.backport175.compiler.parser.ParseContext;
import org.codehaus.backport175.compiler.parser.ParseException;
import org.codehaus.backport175.compiler.parser.ast.ASTAnnotation;
import org.codehaus.backport175.compiler.parser.ast.ASTArray;
import org.codehaus.backport175.compiler.parser.ast.ASTBoolean;
import org.codehaus.backport175.compiler.parser.ast.ASTChar;
import org.codehaus.backport175.compiler.parser.ast.ASTFloat;
import org.codehaus.backport175.compiler.parser.ast.ASTHex;
import org.codehaus.backport175.compiler.parser.ast.ASTIdentifier;
import org.codehaus.backport175.compiler.parser.ast.ASTInteger;
import org.codehaus.backport175.compiler.parser.ast.ASTKeyValuePair;
import org.codehaus.backport175.compiler.parser.ast.ASTOct;
import org.codehaus.backport175.compiler.parser.ast.ASTRoot;
import org.codehaus.backport175.compiler.parser.ast.ASTString;
import org.codehaus.backport175.compiler.parser.ast.AnnotationParserVisitor;
import org.codehaus.backport175.compiler.parser.ast.Node;
import org.codehaus.backport175.compiler.parser.ast.SimpleNode;
import org.codehaus.backport175.org.objectweb.asm.AnnotationVisitor;
import org.codehaus.backport175.org.objectweb.asm.Type;

public class AnnotationParser
implements AnnotationParserVisitor {
    public static final String DEFAULT_VALUE_NAME = "value";
    protected static final org.codehaus.backport175.compiler.parser.ast.AnnotationParser PARSER = new org.codehaus.backport175.compiler.parser.ast.AnnotationParser(System.in);
    protected Class m_annotationClass;
    protected AnnotationVisitor m_bytecodeMunger;
    static /* synthetic */ Class class$java$lang$String;

    public static void parse(AnnotationVisitor bytecodeMunger, RawAnnotation rawAnnotation) {
        AnnotationParser.parse(bytecodeMunger, rawAnnotation, null);
    }

    public static void parse(AnnotationVisitor bytecodeMunger, RawAnnotation rawAnnotation, String desc) {
        String interfaceName = rawAnnotation.getAnnotationClass().getName().replace('/', '.');
        String rawAnnotationValue = rawAnnotation.getValue();
        StringBuffer representation = new StringBuffer("@");
        representation.append(interfaceName).append('(');
        if (rawAnnotationValue != null) {
            representation.append(rawAnnotationValue);
        }
        representation.append(')');
        try {
            AnnotationParser annotationParser = desc != null ? new AnnotationDefaultValueParser(bytecodeMunger, rawAnnotation.getAnnotationClass(), desc) : new AnnotationParser(bytecodeMunger, rawAnnotation.getAnnotationClass());
            annotationParser.visit(PARSER.parse(representation.toString().replace('\n', ' ')), null);
        }
        catch (AnnotationValidationException ave) {
            ave.setLocation(SourceLocation.render(rawAnnotation));
            throw ave;
        }
        catch (Throwable e) {
            throw new ParseException("cannot parse annotation [" + representation.toString() + "] due to: " + e.getMessage(), e, SourceLocation.render(rawAnnotation));
        }
    }

    public Object visit(SimpleNode node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, null);
    }

    public Object visit(ASTRoot node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, null);
    }

    public Object visit(ASTAnnotation node, Object data) {
        ParseContext ctx = (ParseContext)data;
        if (ctx == null) {
            this.handleAnnotation(node, new ParseContext(null, this.m_annotationClass, this.m_bytecodeMunger));
        } else {
            this.handleNestedAnnotation(node, ctx);
        }
        return null;
    }

    public Object visit(ASTKeyValuePair node, Object data) {
        ParseContext ctx = (ParseContext)data;
        ctx.elementName = node.getKey();
        ctx.expectedType = this.getElementTypeFor(ctx.annotationType, ctx.elementName);
        node.jjtGetChild(0).jjtAccept(this, ctx);
        return null;
    }

    public Object visit(ASTIdentifier node, Object data) {
        ParseContext ctx = (ParseContext)data;
        String identifier = node.getValue();
        if (identifier.endsWith(".class")) {
            this.handleClassIdentifier(identifier, ctx);
        } else if (this.isJavaReferenceType(identifier)) {
            this.handleReferenceIdentifier(identifier, ctx);
        } else {
            throw new ParseException("unsupported format for java type or static reference (enum) [" + ctx.elementName + "::" + identifier + "]");
        }
        return null;
    }

    public Object visit(ASTBoolean node, Object data) {
        ParseContext ctx = (ParseContext)data;
        AnnotationValidator.validateBoolean(ctx);
        ctx.munger.visit(ctx.elementName, Boolean.valueOf(node.getValue()));
        return null;
    }

    public Object visit(ASTChar node, Object data) {
        Character character;
        ParseContext ctx = (ParseContext)data;
        AnnotationValidator.validateCharacter(ctx);
        char[] value = node.getValue().trim().toCharArray();
        if (value.length == 1) {
            character = new Character(value[0]);
        } else if (value.length == 3 && value[0] == '\'' && value[2] == '\'') {
            character = new Character(value[1]);
        } else {
            throw new ParseException("could not parse character [" + value + "]");
        }
        ctx.munger.visit(ctx.elementName, character);
        return null;
    }

    public Object visit(ASTString node, Object data) {
        ParseContext ctx = (ParseContext)data;
        AnnotationValidator.validateString(ctx);
        String string = node.getValue().length() >= 2 ? node.getValue().substring(1, node.getValue().length() - 1) : node.getValue();
        string = AnnotationParser.unescapeQuotes(string);
        ctx.munger.visit(ctx.elementName, string);
        return null;
    }

    public Object visit(ASTInteger node, Object data) {
        Number integer;
        ParseContext ctx = (ParseContext)data;
        String value = node.getValue();
        char lastChar = value.charAt(value.length() - 1);
        if (lastChar == 'L' || lastChar == 'l') {
            integer = new Long(value.substring(0, value.length() - 1));
        } else if (value.length() > 9) {
            integer = new Long(value);
            AnnotationValidator.validateLong(ctx);
        } else {
            integer = new Integer(value);
            AnnotationValidator.validateInteger(ctx);
        }
        ctx.munger.visit(ctx.elementName, integer);
        return null;
    }

    public Object visit(ASTFloat node, Object data) {
        Number decimalNumber;
        ParseContext ctx = (ParseContext)data;
        String value = node.getValue();
        char lastChar = value.charAt(value.length() - 1);
        if (lastChar == 'D' || lastChar == 'd') {
            decimalNumber = new Double(value.substring(0, value.length() - 1));
            AnnotationValidator.validateDouble(ctx);
        } else if (lastChar == 'F' || lastChar == 'f') {
            decimalNumber = new Float(value.substring(0, value.length() - 1));
            AnnotationValidator.validateFloat(ctx);
        } else {
            decimalNumber = new Double(value);
            AnnotationValidator.validateDouble(ctx);
        }
        ctx.munger.visit(ctx.elementName, decimalNumber);
        return null;
    }

    public Object visit(ASTHex node, Object data) {
        throw new UnsupportedOperationException("hex numbers not yet supported");
    }

    public Object visit(ASTOct node, Object data) {
        throw new UnsupportedOperationException("octal numbers not yet supported");
    }

    public Object visit(ASTArray node, Object data) {
        ParseContext ctx = (ParseContext)data;
        AnnotationValidator.validateArray(ctx);
        AnnotationVisitor newMunger = ctx.munger.visitArray(ctx.elementName);
        ParseContext newCtx = new ParseContext(ctx.elementName, ctx.annotationType, ctx.expectedType, newMunger);
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            node.jjtGetChild(i).jjtAccept(this, newCtx);
            ++i;
        }
        newMunger.visitEnd();
        return null;
    }

    protected Class getElementTypeFor(Class annotationInterface, String valueName) {
        Class<?> type;
        if (annotationInterface == null) {
            throw new IllegalArgumentException("annotation interface can not be null");
        }
        if (valueName == null) {
            throw new IllegalArgumentException("value name can not be null");
        }
        try {
            type = annotationInterface.getDeclaredMethod(valueName, new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException e) {
            throw new ParseException("no method in annotation interface [" + annotationInterface.getName() + "] matches the value name [" + valueName + "]");
        }
        return type;
    }

    protected void handleAnnotation(ASTAnnotation node, ParseContext ctx) {
        int nr = node.jjtGetNumChildren();
        if (nr == 1) {
            Node childNode = node.jjtGetChild(0);
            ctx.elementName = childNode instanceof ASTKeyValuePair ? ((ASTKeyValuePair)childNode).getKey() : DEFAULT_VALUE_NAME;
            ctx.expectedType = this.getElementTypeFor(ctx.annotationType, ctx.elementName);
            childNode.jjtAccept(this, ctx);
        } else {
            int i = 0;
            while (i < nr) {
                node.jjtGetChild(i).jjtAccept(this, ctx);
                ++i;
            }
        }
    }

    protected void handleNestedAnnotation(ASTAnnotation node, ParseContext ctx) {
        Class<?> annotationType = this.getElementTypeFor(ctx.annotationType, ctx.elementName);
        if (annotationType.isArray()) {
            annotationType = annotationType.getComponentType();
        }
        AnnotationVisitor newMunger = ctx.munger.visitAnnotation(ctx.elementName, Type.getDescriptor(annotationType));
        ParseContext newCtx = new ParseContext(ctx.elementName, annotationType, ctx.expectedType, newMunger);
        AnnotationValidator.validateAnnotation(newCtx);
        AnnotationParser newParser = new AnnotationParser(newMunger, annotationType);
        newParser.handleAnnotation(node, newCtx);
        newMunger.visitEnd();
    }

    protected Object handleClassIdentifier(String identifier, ParseContext ctx) {
        Class componentClass;
        AnnotationValidator.validateClass(ctx);
        int index = identifier.lastIndexOf(46);
        String componentClassName = identifier.substring(0, index);
        int dimension = 0;
        while (componentClassName.endsWith("[]")) {
            ++dimension;
            componentClassName = componentClassName.substring(0, componentClassName.length() - 2);
        }
        boolean isComponentPrimitive = true;
        if (componentClassName.equals("long")) {
            componentClass = Long.TYPE;
        } else if (componentClassName.equals("int")) {
            componentClass = Integer.TYPE;
        } else if (componentClassName.equals("short")) {
            componentClass = Short.TYPE;
        } else if (componentClassName.equals("double")) {
            componentClass = Double.TYPE;
        } else if (componentClassName.equals("float")) {
            componentClass = Float.TYPE;
        } else if (componentClassName.equals("byte")) {
            componentClass = Byte.TYPE;
        } else if (componentClassName.equals("char")) {
            componentClass = Character.TYPE;
        } else if (componentClassName.equals("boolean")) {
            componentClass = Boolean.TYPE;
        } else if (componentClassName.equals("java.lang.String")) {
            componentClass = class$java$lang$String == null ? (class$java$lang$String = AnnotationParser.class$("java.lang.String")) : class$java$lang$String;
        } else {
            isComponentPrimitive = false;
            try {
                componentClass = AnnotationParser.forName(componentClassName, ctx.annotationType);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException("could not load class [" + componentClassName + "] due to: " + e.toString(), e);
            }
        }
        if (isComponentPrimitive) {
            if (dimension <= 0) {
                Type componentType = Type.getType(componentClass);
                ctx.munger.visit(ctx.elementName, componentType);
            } else {
                Class<?> arrayClass = Array.newInstance(componentClass, new int[dimension]).getClass();
                Type componentType = Type.getType(arrayClass);
                ctx.munger.visit(ctx.elementName, componentType);
            }
        } else {
            String componentType = Type.getType(componentClass).getDescriptor();
            int i = 0;
            while (i < dimension) {
                componentType = "[" + componentType;
                ++i;
            }
            Type type = Type.getType(componentType);
            ctx.munger.visit(ctx.elementName, type);
        }
        return null;
    }

    protected Object handleReferenceIdentifier(String identifier, ParseContext ctx) {
        AnnotationValidator.validateEnum(ctx);
        int index = identifier.lastIndexOf(46);
        String className = identifier.substring(0, index);
        String fieldName = identifier.substring(index + 1, identifier.length());
        try {
            Class clazz = AnnotationParser.forName(className, ctx.annotationType);
            ctx.munger.visitEnum(ctx.elementName, Type.getDescriptor(clazz), fieldName);
        }
        catch (Exception e) {
            throw new ParseException("could not access reference field [" + identifier + "] due to: " + e.toString(), e);
        }
        return null;
    }

    protected boolean isJavaReferenceType(String valueAsString) {
        int first = valueAsString.indexOf(46);
        int last = valueAsString.lastIndexOf(46);
        int comma = valueAsString.indexOf(44);
        return first > 0 && last > 0 && first != last && comma < 0;
    }

    private AnnotationParser(AnnotationVisitor bytecodeVisitor, Class annotationClass) {
        this.m_bytecodeMunger = bytecodeVisitor;
        this.m_annotationClass = annotationClass;
    }

    private static Class getClassFromTypeDesc(String typeDesc, Class annotationClass) {
        Class componentClass;
        Type componentType;
        Type type = Type.getType(typeDesc);
        int dimension = typeDesc.startsWith("[") ? type.getDimensions() : 0;
        Type type2 = componentType = typeDesc.startsWith("[") ? type.getElementType() : type;
        if (componentType.equals(Type.LONG_TYPE)) {
            componentClass = Long.TYPE;
        } else if (componentType.equals(Type.INT_TYPE)) {
            componentClass = Integer.TYPE;
        } else if (componentType.equals(Type.SHORT_TYPE)) {
            componentClass = Short.TYPE;
        } else if (componentType.equals(Type.DOUBLE_TYPE)) {
            componentClass = Double.TYPE;
        } else if (componentType.equals(Type.FLOAT_TYPE)) {
            componentClass = Float.TYPE;
        } else if (componentType.equals(Type.BYTE_TYPE)) {
            componentClass = Byte.TYPE;
        } else if (componentType.equals(Type.CHAR_TYPE)) {
            componentClass = Character.TYPE;
        } else if (componentType.equals(Type.BOOLEAN_TYPE)) {
            componentClass = Boolean.TYPE;
        } else if (componentType.equals(Type.getType(class$java$lang$String == null ? (class$java$lang$String = AnnotationParser.class$("java.lang.String")) : class$java$lang$String))) {
            componentClass = class$java$lang$String == null ? (class$java$lang$String = AnnotationParser.class$("java.lang.String")) : class$java$lang$String;
        } else {
            try {
                componentClass = AnnotationParser.forName(componentType.getClassName(), annotationClass);
            }
            catch (ClassNotFoundException e) {
                throw new ParseException("could not load class for type [" + typeDesc + "] due to: " + e.toString(), e);
            }
        }
        if (dimension <= 0) {
            return componentClass;
        }
        Class<?> arrayClass = Array.newInstance(componentClass, new int[dimension]).getClass();
        return arrayClass;
    }

    private static Class forName(String name, Class annotationClass) throws ClassNotFoundException {
        ClassLoader loader = annotationClass.getClassLoader() != null ? annotationClass.getClassLoader() : Thread.currentThread().getContextClassLoader();
        return Class.forName(name, false, loader);
    }

    private static String unescapeQuotes(String string) {
        int index = string.indexOf("\\\"");
        if (index >= 0) {
            char[] newString = new char[string.length() - 1];
            int j = 0;
            int i = 0;
            while (i < string.length()) {
                if (i == index) {
                    newString[j] = 34;
                    ++i;
                } else {
                    newString[j] = string.charAt(i);
                }
                ++j;
                ++i;
            }
            return AnnotationParser.unescapeQuotes(new String(newString));
        }
        return string;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AnnotationDefaultValueParser
    extends AnnotationParser {
        private final String m_typeDesc;
        private Class m_typeClassLazy = null;

        private AnnotationDefaultValueParser(AnnotationVisitor bytecodeVisitor, Class annotationClass, String desc) {
            super(bytecodeVisitor, annotationClass);
            this.m_typeDesc = desc;
        }

        protected Class getElementTypeFor(Class annotationInterface, String valueName) {
            if (annotationInterface == null) {
                throw new IllegalArgumentException("annotation interface can not be null");
            }
            if (valueName == null) {
                throw new IllegalArgumentException("value name can not be null");
            }
            if (!valueName.equals(AnnotationParser.DEFAULT_VALUE_NAME)) {
                throw new IllegalArgumentException("value name must be 'value' for annotation default value");
            }
            if (this.m_typeClassLazy == null) {
                this.m_typeClassLazy = AnnotationParser.getClassFromTypeDesc(this.m_typeDesc, this.m_annotationClass);
            }
            return this.m_typeClassLazy;
        }
    }
}

