/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.compiler;

import org.codehaus.backport175.compiler.CompilerException;
import org.codehaus.backport175.compiler.SourceLocation;

public interface MessageHandler {
    public void info(String var1);

    public void error(CompilerException var1);

    public void accept(SourceLocation var1);

    public static class PrintWriter
    implements MessageHandler {
        private boolean m_verbose = false;

        public PrintWriter(boolean isVerbose) {
            this.m_verbose = isVerbose;
        }

        public void info(String message) {
            if (this.m_verbose) {
                System.out.println("INFO: " + message);
            }
        }

        public void warning(String message) {
            if (this.m_verbose) {
                System.out.println("WARNING: " + message);
            }
        }

        public void error(CompilerException exception) {
            if (exception.getLocation() != null) {
                System.err.println("ERROR: " + exception.getLocation().toString());
            } else {
                System.err.println("ERROR:");
            }
            exception.printStackTrace();
        }

        public void accept(SourceLocation sourceLocation) {
        }
    }
}

