/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.backport175.com.thoughtworks.qdox.directorywalker;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.codehaus.backport175.com.thoughtworks.qdox.directorywalker.FileVisitor;
import org.codehaus.backport175.com.thoughtworks.qdox.directorywalker.Filter;

public class DirectoryScanner {
    private File _file;
    private Collection _filters = new HashSet();

    public DirectoryScanner(File file) {
        this._file = file;
    }

    public File[] scan() {
        final ArrayList results = new ArrayList();
        this.walk(new FileVisitor(){

            public void visitFile(File file) {
                results.add(file);
            }
        }, this._file);
        File[] resultsArray = new File[results.size()];
        results.toArray(resultsArray);
        return resultsArray;
    }

    private void walk(FileVisitor visitor, File current) {
        if (current.isDirectory()) {
            File[] currentFiles = current.listFiles();
            for (int i = 0; i < currentFiles.length; ++i) {
                this.walk(visitor, currentFiles[i]);
            }
        } else {
            Iterator iterator = this._filters.iterator();
            while (iterator.hasNext()) {
                Filter filter = (Filter)iterator.next();
                if (filter.filter(current)) continue;
                return;
            }
            visitor.visitFile(current);
        }
    }

    public void addFilter(Filter filter) {
        this._filters.add(filter);
    }

    public void scan(FileVisitor fileVisitor) {
        this.walk(fileVisitor, this._file);
    }
}

