/*
 * Decompiled with CFR 0.152.
 */
package org.seasar.extension.dataset.types;

import java.util.HashMap;
import java.util.Map;
import org.seasar.extension.dataset.ColumnType;
import org.seasar.extension.dataset.types.BigDecimalType;
import org.seasar.extension.dataset.types.BinaryType;
import org.seasar.extension.dataset.types.ObjectType;
import org.seasar.extension.dataset.types.StringType;
import org.seasar.extension.dataset.types.TimestampType;
import org.seasar.extension.jdbc.ValueType;
import org.seasar.extension.jdbc.types.ValueTypes;

public class ColumnTypes {
    public static final ColumnType STRING = new StringType();
    public static final ColumnType BIGDECIMAL = new BigDecimalType();
    public static final ColumnType TIMESTAMP = new TimestampType();
    public static final ColumnType BINARY = new BinaryType();
    public static final ColumnType OBJECT = new ObjectType();
    private static Map types_ = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$util$Calendar;

    public static ValueType getValueType(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return ValueTypes.BIGDECIMAL;
            }
            case 91: 
            case 92: 
            case 93: {
                return ValueTypes.TIMESTAMP;
            }
            case -4: 
            case -3: 
            case -2: {
                return ValueTypes.BINARY;
            }
            case -1: 
            case 1: 
            case 12: {
                return ValueTypes.STRING;
            }
        }
        return ValueTypes.OBJECT;
    }

    public static ColumnType getColumnType(int type) {
        switch (type) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return BIGDECIMAL;
            }
            case 91: 
            case 92: 
            case 93: {
                return TIMESTAMP;
            }
            case -4: 
            case -3: 
            case -2: {
                return BINARY;
            }
            case -1: 
            case 1: 
            case 12: {
                return STRING;
            }
        }
        return OBJECT;
    }

    public static ColumnType getColumnType(Object value) {
        if (value == null) {
            return OBJECT;
        }
        return ColumnTypes.getColumnType(value.getClass());
    }

    public static ColumnType getColumnType(Class clazz) {
        ColumnType columnType = ColumnTypes.getColumnType0(clazz);
        if (columnType != null) {
            return columnType;
        }
        return OBJECT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ColumnType getColumnType0(Class clazz) {
        Map map = types_;
        synchronized (map) {
            return (ColumnType)types_.get(clazz);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        types_.put(class$java$lang$String == null ? (class$java$lang$String = ColumnTypes.class$("java.lang.String")) : class$java$lang$String, STRING);
        types_.put(Short.TYPE, BIGDECIMAL);
        types_.put(class$java$lang$Short == null ? (class$java$lang$Short = ColumnTypes.class$("java.lang.Short")) : class$java$lang$Short, BIGDECIMAL);
        types_.put(Integer.TYPE, BIGDECIMAL);
        types_.put(class$java$lang$Integer == null ? (class$java$lang$Integer = ColumnTypes.class$("java.lang.Integer")) : class$java$lang$Integer, BIGDECIMAL);
        types_.put(Long.TYPE, BIGDECIMAL);
        types_.put(class$java$lang$Long == null ? (class$java$lang$Long = ColumnTypes.class$("java.lang.Long")) : class$java$lang$Long, BIGDECIMAL);
        types_.put(Float.TYPE, BIGDECIMAL);
        types_.put(class$java$lang$Float == null ? (class$java$lang$Float = ColumnTypes.class$("java.lang.Float")) : class$java$lang$Float, BIGDECIMAL);
        types_.put(Double.TYPE, BIGDECIMAL);
        types_.put(class$java$lang$Double == null ? (class$java$lang$Double = ColumnTypes.class$("java.lang.Double")) : class$java$lang$Double, BIGDECIMAL);
        types_.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ColumnTypes.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, BIGDECIMAL);
        types_.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = ColumnTypes.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, TIMESTAMP);
        types_.put(class$java$sql$Date == null ? (class$java$sql$Date = ColumnTypes.class$("java.sql.Date")) : class$java$sql$Date, TIMESTAMP);
        types_.put(class$java$util$Date == null ? (class$java$util$Date = ColumnTypes.class$("java.util.Date")) : class$java$util$Date, TIMESTAMP);
        types_.put(class$java$util$Calendar == null ? (class$java$util$Calendar = ColumnTypes.class$("java.util.Calendar")) : class$java$util$Calendar, TIMESTAMP);
        types_.put(new byte[0].getClass(), BINARY);
    }
}

