/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.axis;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.axis.deployment.wsdd.WSDDConstants;

/**
 * dicont@CAxisT[rX̏ݒ肷邽߂Ɏg܂B
 * 
 * @author koichik
 */
public class ServiceDef {
    //instance fields
    protected String provider = WSDDConstants.PROVIDER_RPC;
    protected Class serviceType;
    protected String allowedMethods;
    protected final List typeMappingDefs = new ArrayList();

    /**
     * voC_Ԃ܂B
     * 
     * @return Returns the providerType.
     */
    public String getProvider() {
        return provider;
    }

    /**
     * voC_w肵܂B
     * 
     * @param providerType
     *            The providerType to set.
     */
    public void setProvider(final String providerType) {
        this.provider = providerType;
    }

    /**
     * T[rX̌^Ԃ܂B
     * 
     * @return Returns the serviceType.
     */
    public Class getServiceType() {
        return serviceType;
    }

    /**
     * T[rX̌^ݒ肵܂B
     * 
     * @param serviceType
     *            The serviceType to set.
     */
    public void setServiceType(final Class serviceType) {
        this.serviceType = serviceType;
    }

    /**
     * T[rXƂČJ郁\bhԂ܂B
     * 
     * @return Returns the allowedMethods.
     */
    public String getAllowedMethods() {
        return allowedMethods;
    }

    /**
     * T[rXƂČJ郁\bhݒ肵܂B
     * 
     * @param allowedMethods
     *            The allowedMethods to set.
     */
    public void setAllowedMethods(final String allowedMethods) {
        this.allowedMethods = allowedMethods;
    }

    /**
     * ^Cv}bsOǉ܂B
     * 
     * @param typeMappingDef
     */
    public void addTypeMapping(final TypeMappingDef typeMappingDef) {
        typeMappingDefs.add(typeMappingDef);
    }

    /**
     * ^Cv}bsÕCe[^Ԃ܂B
     * 
     * @return Returns the TypeMappings.
     */
    public Iterator getTypeMappings() {
        return typeMappingDefs.iterator();
    }
}
