package org.seasar.remoting.axis.connector;

import javax.xml.rpc.encoding.TypeMapping;

import junit.framework.TestCase;

import org.apache.axis.client.Service;
import org.apache.axis.enum.Use;
import org.seasar.remoting.axis.encoding.AutoRegisterTypeMappingImpl;

/**
 * @author koichik
 */
public class AxisConnectorTest extends TestCase {
    public AxisConnectorTest() {
    }

    public AxisConnectorTest(String name) {
        super(name);
    }

    public void testSetService() {
        Service service = new Service();

        AxisConnector connector = new AxisConnector();
        connector.setService(service);

        TypeMapping tm = service.getTypeMappingRegistry().getTypeMapping(Use.DEFAULT.getEncoding());
        assertTrue(tm instanceof AutoRegisterTypeMappingImpl);

        connector = new AxisConnector();
        connector.setService(service);
        assertSame(tm, service.getTypeMappingRegistry().getTypeMapping(Use.DEFAULT.getEncoding()));
    }
}