/*
 *
 * The Seasar Software License, Version 1.1
 *
 * Copyright (c) 2003-2004 The Seasar Project. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the following
 * conditions are met:
 *
 * 1. Redistributions of source code must retain the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above
 *    copyright notice, this list of conditions and the following
 *    disclaimer in the documentation and/or other materials provided
 *    with the distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgement:
 *    "This product includes software developed by the
 *    Seasar Project (http://www.seasar.org/)."
 *    Alternately, this acknowledgement may appear in the software
 *    itself, if and wherever such third-party acknowledgements
 *    normally appear.
 *
 * 4. Neither the name "The Seasar Project" nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission of
 *    the Seasar Project.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE SEASAR PROJECT
 * OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL,SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package org.seasar.remoting.axis.deployment.provider;

import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.deployment.wsdd.WSDDService;
import org.seasar.remoting.axis.S2AxisConstants;
import org.seasar.remoting.axis.deployment.WSDDS2Service;
import org.seasar.remoting.axis.providers.S2MsgProvider;

/**
 * S2ReiMSG^̃T[rX擾voC_̃t@NgłB <br>
 * ̃NX́A <code>s2-axis.jar</code> t@C
 * <code>META-INF/services/org.apache.axis.deployment.wsdd.Provider</code>
 * ɋLq邱ƂɂA <code>org.apache.axis.wsdd.WSDDProvider</code> ɓo^܂B
 * 
 * @author koichik
 */
public class WSDDS2MsgProvider extends WSDDProvider {

    /**
     * ̃voC_ʂ郍[JԂ܂B
     * 
     * @return ̃voC_ʂ郍[J
     */
    public String getName() {
        return S2AxisConstants.PROVIDER_S2MSG;
    }

    /**
     * VvoC_̃CX^X𐶐ĕԂ܂B
     *
     * @param service WSDDS2ServicẽCX^X
     * @param registry nh̃WXg 
     */
    public Handler newProviderInstance(final WSDDService service, final EngineConfiguration registry)
            throws Exception {
        return new S2MsgProvider(((WSDDS2Service) service).getComponentDef());
    }
}