package org.seasar.struts.processor;

import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.seasar.extension.unit.S2TestCase;
import org.seasar.struts.action.POJOAction;
import org.seasar.struts.action.POJOActionImpl;
import org.seasar.struts.action.ReturnNullPOJOAction;
import org.seasar.struts.action.ReturnNullPOJOActionImpl;
import org.seasar.struts.unit.mock.MockActionMapping;

/**
 * @author Satoshi Kimura
 */
public class ActionExecuteProcessorImplTest extends S2TestCase {
    private ActionExecuteProcessor actionExecuteProcessor;

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
        include("s2struts.dicon");
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /**
     * Constructor for ActionExecuteProcessorImplTest.
     * 
     * @param arg0
     */
    public ActionExecuteProcessorImplTest(String arg0) {
        super(arg0);
    }

    public void setUpProcessActionExecute() {
        include("ActionExecuteProcessorImplTest.dicon");
    }

    public void testProcessActionExecute() throws Exception {
        POJOActionImpl action = new POJOActionImpl();
        Object form = null;
        ActionMapping mapping = new MockActionMapping();
        mapping.setType(POJOAction.class.getName());

        ActionForward actionForward = actionExecuteProcessor.processActionExecute(getRequest(), getResponse(), action,
                form, mapping);
        assertEquals("success", actionForward.getName());
    }

    public void setUpProcessActionExecuteReturnNull() {
        include("ActionExecuteProcessorImplReturnNullTest.dicon");
    }

    public void testProcessActionExecuteReturnNull() throws Exception {
        ReturnNullPOJOAction action = new ReturnNullPOJOActionImpl();
        Object form = null;
        ActionMapping mapping = new MockActionMapping();
        mapping.setType(ReturnNullPOJOAction.class.getName());

        ActionForward actionForward = actionExecuteProcessor.processActionExecute(getRequest(), getResponse(), action,
                form, mapping);
        assertNull(actionForward);
    }


    // TODO NGXg ZbV tH[

}