/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry.form;

import org.apache.tapestry.IActionListener;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IForm;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.form.AbstractFormComponent;

public abstract class Submit
extends AbstractFormComponent {
    protected void renderComponent(IMarkupWriter writer, IRequestCycle cycle) {
        String label;
        IForm form = this.getForm(cycle);
        boolean rewinding = form.isRewinding();
        String name = form.getElementId(this);
        if (rewinding) {
            IActionListener listener;
            if (this.isDisabled()) {
                return;
            }
            String value = cycle.getRequestContext().getParameter(name);
            if (value == null) {
                return;
            }
            IBinding selectedBinding = this.getSelectedBinding();
            if (selectedBinding != null) {
                selectedBinding.setObject(this.getTag());
            }
            if ((listener = this.getListener()) != null) {
                listener.actionTriggered(this, cycle);
            }
            return;
        }
        writer.beginEmpty("input");
        writer.attribute("type", "submit");
        writer.attribute("name", name);
        if (this.isDisabled()) {
            writer.attribute("disabled", "disabled");
        }
        if ((label = this.getLabel()) != null) {
            writer.attribute("value", label);
        }
        this.renderInformalParameters(writer, cycle);
        writer.closeTag();
    }

    public abstract String getLabel();

    public abstract IBinding getSelectedBinding();

    public abstract boolean isDisabled();

    public abstract IActionListener getListener();

    public abstract Object getTag();
}

