package org.maachang.rimdb.util;

/**
 * オブジェクトKeyオブジェクトValue子要素.
 * 
 * @version 2014/07/21
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class OOChild<K, V> {
	public V o;
	protected K b;
	protected OOChild<K, V> n;

	/**
	 * コンストラクタ.
	 * 
	 * @param k
	 *            対象のキーを設定します.
	 * @param v
	 *            対象の要素を設定します.
	 */
	protected OOChild(K k, V v) {
		b = k;
		o = v;
	}

	/**
	 * 対象のキーを取得.
	 * 
	 * @return K 対象のキーコードが返却されます.
	 */
	public final K getKey() {
		return b;
	}

	/**
	 * 対象の要素を取得.
	 * 
	 * @return T 対象の要素が返却されます.
	 */
	public final V getValue() {
		return o;
	}

	/**
	 * 対象の要素を変更.
	 * 
	 * @param v
	 *            要素を設定します.
	 */
	public final void setValue(final V v) {
		o = v;
	}

}
