package org.maachang.rimdb.util;

/**
 * 数字追加条件.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public interface NAdd {

	/**
	 * 情報クリア.
	 */
	public void clear();

	/**
	 * 配列の長さを指定して、情報クリア.
	 * 
	 * @param buf
	 *            対象の長さを設定します.
	 */
	public void clear(int buf);

	/**
	 * 情報追加.
	 * 
	 * @param n
	 *            対象の数値を設定します.
	 */
	public void add(int n);

	/**
	 * 情報取得.
	 * 
	 * @param no
	 *            対象の項番を設定します.
	 * @return int 対象条件が返却されます.
	 */
	public int get(int no);

	/**
	 * サイズを取得.
	 * 
	 * @return int サイズが返却されます.
	 */
	public int size();

	/**
	 * 配列を取得.
	 * 
	 * @return int[] 配列が返却されます.
	 */
	public int[] getArray();

	/**
	 * 素の配列を取得.
	 * 
	 * @return int[] 素の配列が返却されます.
	 */
	public int[] toArray();
}
