package org.maachang.rimdb.table.array;

import org.maachang.rimdb.ColumnType;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.util.NList;

/**
 * Timestamp配列.
 * 
 * @version 2014/07/07
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class TimestampArray implements ColumnArray<java.sql.Timestamp> {
	private long[] list;
	private int[] nullList;

	/**
	 * コンストラクタ.
	 * 
	 * @param columns
	 *            カラム群を設定します.
	 */
	public TimestampArray(final java.util.Date[] columns) {
		final NList nulls = new NList();
		final int len = columns.length;
		final long[] n = new long[len];
		for (int i = 0; i < len; i++) {
			if (columns[i] == null) {
				nulls.add(i);
			} else {
				n[i] = columns[i].getTime();
			}
		}
		list = n;
		if (nulls.size() == 0) {
			nullList = null;
		} else {
			nullList = nulls.sort().getArray();
		}
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param columns
	 *            カラム群を設定します.
	 */
	public TimestampArray(final java.sql.Timestamp[] columns) {
		final NList nulls = new NList();
		final int len = columns.length;
		final long[] n = new long[len];
		for (int i = 0; i < len; i++) {
			if (columns[i] == null) {
				nulls.add(i);
			} else {
				n[i] = columns[i].getTime();
			}
		}
		list = n;
		if (nulls.size() == 0) {
			nullList = null;
		} else {
			nullList = nulls.sort().getArray();
		}
	}

	/**
	 * カラムタイプを取得.
	 * 
	 * @return int カラムタイプが返却されます.
	 */
	public final int getType() {
		return ColumnType.TYPE_TIMESTAMP;
	}

	/**
	 * 指定位置の情報を取得.
	 * 
	 * @param no
	 *            対象の項番を設定します.
	 * @return java.sql.Timestamp 情報が返却されます.
	 */
	public final java.sql.Timestamp get(final int no) {
		if (nullList != null && IndexUtil.searchInt(nullList, no) != -1) {
			return null;
		}
		return new java.sql.Timestamp(list[no]);
	}

	/**
	 * 指定位置の情報を取得.
	 * 
	 * @param out
	 *            出力対象の情報を設定します.
	 * @param no
	 *            対象の項番を設定します.
	 * @return java.sql.Timestamp 情報が返却されます.
	 */
	public final java.sql.Timestamp get(final java.sql.Timestamp out,
			final int no) {
		if (nullList != null && IndexUtil.searchInt(nullList, no) != -1) {
			return null;
		}
		out.setTime(list[no]);
		return out;
	}
}
