package org.maachang.rimdb.table;

import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.table.array.UniqueId;

/**
 * ユニークカラムテーブル.
 * 
 * @version 2014/07/07
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class Uniques {

	protected final int[] columns;
	protected final UniqueId[] list;
	protected final int length;

	/**
	 * コンストラクタ.
	 * 
	 * @param columns
	 *            対象のインデックス列項番を設定します.
	 * @param list
	 *            ユニークIDリストを設定します.
	 */
	public Uniques(int[] columns, UniqueId[] list) {
		this.columns = columns;
		this.list = list;
		this.length = list.length;
	}

	/**
	 * 指定項番にユニーク情報が存在するかチェック.
	 * 
	 * @param no
	 *            対象の項番を設定します.
	 * @return boolean [true]の場合、ユニーク情報は存在します.
	 */
	public final boolean contains(final int no) {
		return IndexUtil.searchInt(columns, no) != -1;
	}

	/**
	 * カラム数を取得.
	 * 
	 * @return int カラム数が返却されます.
	 */
	public final int length() {
		return length;
	}

	/**
	 * 対象情報の行番号を取得.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @param id
	 *            対象のユニークIDを設定します.
	 * @return int 対象の行番号が返却されます. 見つからない場合は[-1]が返却されます.
	 */
	public final int search(final int no, final int id) {
		final int p = IndexUtil.searchInt(columns, no);
		if (p == -1) {
			return -1;
		}
		return list[p].search(id);
	}

	/**
	 * 対象情報の行番号を取得.
	 * 
	 * @param no
	 *            対象のカラム項番を設定します.
	 * @param id
	 *            対象のユニークIDを設定します.
	 * @return int 対象の行番号が返却されます. 見つからない場合は[-1]が返却されます.
	 */
	public final int search(final int no, final long id) {
		final int p = IndexUtil.searchInt(columns, no);
		if (p == -1) {
			return -1;
		}
		return list[p].search(id);
	}

}
