package org.maachang.rimdb.search;

import org.maachang.rimdb.index.Pointer;
import org.maachang.rimdb.index.position.PositionIndexPointer;

/**
 * 空間インデックス検索ブロック.
 * 
 * @version 2014/07/13
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class PositionBlock implements Block<PositionIndexPointer> {
	protected PositionBlock() {
	}

	/** 検索条件. **/
	private PositionIndexPointer pointer;

	/** ブロックタイプ. **/
	private int type;

	/**
	 * コンストラクタ.
	 * 
	 * @param t
	 *            対象の検索タイプを設定します.
	 * @param p
	 *            対象の検索ポインタを設定します.
	 */
	protected PositionBlock(int t, Pointer p) {
		pointer = (PositionIndexPointer) p;
		type = t;
	}

	/**
	 * ブロックタイプを取得.
	 * 
	 * @return int ブロックタイプが返却されます.
	 */
	public final int getType() {
		return type;
	}

	/**
	 * 検索ポインタリストを取得.
	 * 
	 * @return Pointer 検索ポインタリストが返却されます.
	 */
	public final PositionIndexPointer get() {
		return pointer;
	}

	/**
	 * 文字情報表示.
	 * 
	 * @return String 文字情報を表示します.
	 */
	public final String toString() {
		return new StringBuilder(" [PositionBlock]:").append("[").append(type)
				.append("] ").append(pointer).toString();
	}
}
