package org.maachang.rimdb.index.string;

import org.maachang.rimdb.index.LikePointer;
import org.maachang.rimdb.util.ConvertUtil;

/**
 * String(IString)部分一致検索ポインタ.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class StringLike extends LikePointer<IString> {
	protected StringLike() {
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 */
	public StringLike(StringIndex index) {
		this.type = TYPE_LIKE;
		this.columnName = index.getColumnName();
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param word
	 *            Like検索用条件を設定します.
	 */
	public StringLike(StringIndex index, String word) {
		this(index);
		set(word);
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param word
	 *            Like検索用条件を設定します.
	 */
	public StringLike(StringIndex index, Object word) {
		this(index);
		parameter(word);
	}

	/**
	 * 情報セット.
	 * 
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public final void parameter(final Object word) {
		set(ConvertUtil.convertString(word));
	}

	/**
	 * オブジェクトコピー.
	 * 
	 * @param mode
	 *            [true]を設定した場合、パラメータ情報はコピーされません.
	 * @return SearchPointer コピーされたオブジェクトが返却されます.
	 */
	public final StringLike copy(final boolean mode) {
		StringLike ret = new StringLike();
		baseCopy(mode, ret);
		return ret;
	}
}
