package org.maachang.rimdb.index.string;

/**
 * Likeパーサー.
 * 
 * @version 2014/07/04
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class LikeParser {

	/** 先頭位置を示す **/
	public static final int POS_FIRST = 0;

	/** 終端を示す **/
	public static final int POS_LAST = -9;

	/** 文字数無限 **/
	public static final int POS_BETWEEN = -1;

	protected Object[] parser;
	protected String src;

	public LikeParser(final Object[] p, final String s) {
		parser = p;
		src = s;
	}

	/**
	 * Like文の取得.
	 * 
	 * @return String Like文が返却されます.
	 */
	public final String getSrc() {
		return src;
	}

	/**
	 * パーサーを取得.
	 * 
	 * @param no
	 *            対象の項番を設定します.
	 * @return Object 対象項番のパーサー情報が返却されます.
	 */
	public final Object get(final int no) {
		return parser[no];
	}

	/**
	 * 情報長の取得.
	 * 
	 * @return int 情報長が返却されます.
	 */
	public final int size() {
		return parser.length;
	}

	/**
	 * 全パーサー情報を取得.
	 * 
	 * @return Object[] 全パーサー情報が返却されます.
	 */
	public final Object[] getAll() {
		return parser;
	}

	/**
	 * パーサー内容を入れ替え.
	 * 
	 * @param o
	 *            入れ替え対象のオブジェクトを設定します.
	 */
	public final void set(final Object[] o) {
		parser = o;
	}

	/**
	 * パーサー内容を文字列化.
	 * 
	 * @return String 文字列内容が返却されます.
	 */
	public final String toString() {
		final StringBuilder buf = new StringBuilder();
		int len = parser.length;
		Object n;
		int nn;
		for (int i = 0; i < len; i++) {
			if (i != 0) {
				buf.append(" , ");
			}
			n = parser[i];
			if (n instanceof Integer) {
				nn = (Integer) n;
				if (nn == LikeParser.POS_FIRST) {
					buf.append("[Start]");
				} else if (nn == LikeParser.POS_LAST) {
					buf.append("[LAST]");
				} else if (nn == LikeParser.POS_BETWEEN) {
					buf.append("[*]");
				} else {
					buf.append("[").append(nn).append(":LEN]");
				}
			} else {
				buf.append(n);
			}
		}
		return buf.toString();
	}

}
