package org.maachang.rimdb.index.position;

import org.maachang.rimdb.index.SortComparable;

/**
 * 半径ソート.
 * 
 * @version 2014/07/07
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class RadiusSort implements SortComparable {

	/** 行に対する現在位置. **/
	protected final int[] xList;
	protected final int[] yList;

	/** 指定座標. **/
	protected final int x;
	protected final int y;

	/**
	 * コンストラクタ.
	 * 
	 * @param xList
	 *            対象のXリストを設定します.
	 * @param yList
	 *            対象のYリストを設定します.
	 * @param x
	 *            対象のX軸を設定します.
	 * @param y
	 *            対象のY軸を設定します.
	 */
	protected RadiusSort(final int[] xList, final int[] yList, final int x,
			final int y) {
		this.xList = xList;
		this.yList = yList;
		this.x = x;
		this.y = y;
	}

	/**
	 * 指定行数に対する距離を取得.
	 * 
	 * @param no
	 *            対象の行番号を設定します.
	 * @return int 距離が返却されます.
	 */
	public final int getLine(final int no) {
		return PositionIndex.getLine(xList[no], yList[no], x, y);
	}

	/**
	 * 比較処理.
	 * 
	 * @param src
	 *            チェック開始条件を設定します.
	 * @param dest
	 *            チェック終了条件を設定します.
	 * @return int 比較結果が返されます.
	 */
	public final int comparable(final int src, final int dest) {
		final int s, d;
		if ((s = getLine(src)) > (d = getLine(dest))) {
			return 1;
		} else if (s < d) {
			return -1;
		}
		return 0;
	}

}
