package org.maachang.rimdb.index.numberFloat;

import org.maachang.rimdb.index.WherePointer;

/**
 * Float(double)一致,不一致ポインタ.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class NumberFloatEq extends WherePointer<Double> {
	protected NumberFloatEq() {
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            一致条件で処理する場合は[true]を設定, 不一致で処理する場合は[false]を設定します.
	 */
	public NumberFloatEq(NumberFloatIndex index, boolean eq) {
		if (eq) {
			this.type = TYPE_EQ;
		} else {
			this.type = TYPE_NE;
		}
		this.columnName = index.getColumnName();
		this.eq = eq;
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            一致条件で処理する場合は[true]を設定, 不一致で処理する場合は[false]を設定します.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public NumberFloatEq(NumberFloatIndex index, boolean eq, double word) {
		this(index, eq);
		set(word);
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            一致条件で処理する場合は[true]を設定, 不一致で処理する場合は[false]を設定します.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public NumberFloatEq(NumberFloatIndex index, boolean eq, Object word) {
		this(index, eq);
		parameter(word);
	}

	/**
	 * 情報セット.
	 * 
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public final void parameter(final Object word) {
		set(NumberFloatIn.convert(word));
	}

	/**
	 * オブジェクトコピー.
	 * 
	 * @param mode
	 *            [true]を設定した場合、パラメータ情報はコピーされません.
	 * @return SearchPointer コピーされたオブジェクトが返却されます.
	 */
	public final NumberFloatEq copy(final boolean mode) {
		NumberFloatEq ret = new NumberFloatEq();
		baseCopy(mode, ret);
		return ret;
	}
}
