package org.maachang.rimdb.index.numberFloat;

import org.maachang.rimdb.index.BetweenPointer;

/**
 * Float(double)一致ポインタ.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class NumberFloatBetween extends BetweenPointer<Double> {
	protected NumberFloatBetween() {
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 */
	public NumberFloatBetween(NumberFloatIndex index) {
		this.type = TYPE_BETWEEN;
		this.columnName = index.getColumnName();
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param start
	 *            対象の開始検索ワードを設定します.
	 * @param end
	 *            対象の終了検索ワードを設定します.
	 */
	public NumberFloatBetween(NumberFloatIndex index, double start, double end) {
		this(index);
		set(start, end);
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param start
	 *            対象の開始検索ワードを設定します.
	 * @param end
	 *            対象の終了検索ワードを設定します.
	 */
	public NumberFloatBetween(NumberFloatIndex index, Object start, Object end) {
		this(index);
		parameter(start, end);
	}

	/**
	 * 情報セット.
	 * 
	 * @param start
	 *            対象の開始ワード情報を設定します.
	 * @param end
	 *            対象の終了ワード情報を設定します.
	 */
	public final void parameter(final Object start, final Object end) {
		set(NumberFloatIn.convert(start), NumberFloatIn.convert(end));
	}

	/**
	 * オブジェクトコピー.
	 * 
	 * @param mode
	 *            [true]を設定した場合、パラメータ情報はコピーされません.
	 * @return SearchPointer コピーされたオブジェクトが返却されます.
	 */
	public final NumberFloatBetween copy(final boolean mode) {
		NumberFloatBetween ret = new NumberFloatBetween();
		baseCopy(mode, ret);
		return ret;
	}
}
