package org.maachang.rimdb.index.number32;

import org.maachang.rimdb.index.WherePointer;

/**
 * Number32(int)一致,不一致ポインタ.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class Number32Eq extends WherePointer<Integer> {
	protected Number32Eq() {
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            一致条件で処理する場合は[true]を設定, 不一致で処理する場合は[false]を設定します.
	 */
	public Number32Eq(Number32Index index, boolean eq) {
		if (eq) {
			this.type = TYPE_EQ;
		} else {
			this.type = TYPE_NE;
		}
		this.columnName = index.getColumnName();
		this.eq = eq;
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            一致条件で処理する場合は[true]を設定, 不一致で処理する場合は[false]を設定します.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public Number32Eq(Number32Index index, boolean eq, int word) {
		this(index, eq);
		set(word);
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            一致条件で処理する場合は[true]を設定, 不一致で処理する場合は[false]を設定します.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public Number32Eq(Number32Index index, boolean eq, Object word) {
		this(index, eq);
		parameter(word);
	}

	/**
	 * 情報セット.
	 * 
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public final void parameter(final Object word) {
		set(Number32In.convert(word));
	}

	/**
	 * オブジェクトコピー.
	 * 
	 * @param mode
	 *            [true]を設定した場合、パラメータ情報はコピーされません.
	 * @return SearchPointer コピーされたオブジェクトが返却されます.
	 */
	public final Number32Eq copy(final boolean mode) {
		Number32Eq ret = new Number32Eq();
		baseCopy(mode, ret);
		return ret;
	}
}
