package org.maachang.rimdb.index.comparable;

import org.maachang.rimdb.index.WherePointer;

/**
 * Comparable(比較可能なJavaオブジェクト)一致,不一致ポインタ.
 * 
 * @version 2014/06/29
 * @author masahito suzuki
 * @since rimdb-1.00
 */
@SuppressWarnings("unchecked")
public final class ComparableEq extends WherePointer<Comparable> {
	protected ComparableEq() {
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            一致条件で処理する場合は[true]を設定, 不一致で処理する場合は[false]を設定します.
	 */
	public ComparableEq(ComparableIndex index, boolean eq) {
		if (eq) {
			this.type = TYPE_EQ;
		} else {
			this.type = TYPE_NE;
		}
		this.columnName = index.getColumnName();
		this.eq = eq;
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            一致条件で処理する場合は[true]を設定, 不一致で処理する場合は[false]を設定します.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public ComparableEq(ComparableIndex index, boolean eq, Comparable word) {
		this(index, eq);
		set(word);
	}

	/**
	 * コンストラクタ.
	 * 
	 * @param index
	 *            対象のインデックスを設定します.
	 * @param eq
	 *            一致条件で処理する場合は[true]を設定, 不一致で処理する場合は[false]を設定します.
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public ComparableEq(ComparableIndex index, boolean eq, Object word) {
		this(index, eq);
		parameter(word);
	}

	/**
	 * 情報セット.
	 * 
	 * @param word
	 *            対象の検索ワードを設定します.
	 */
	public final void parameter(final Object word) {
		set(ComparableIn.convert(word));
	}

	/**
	 * オブジェクトコピー.
	 * 
	 * @param mode
	 *            [true]を設定した場合、パラメータ情報はコピーされません.
	 * @return SearchPointer コピーされたオブジェクトが返却されます.
	 */
	public final ComparableEq copy(final boolean mode) {
		ComparableEq ret = new ComparableEq();
		baseCopy(mode, ret);
		return ret;
	}
}
