package org.maachang.rimdb;

import java.util.Iterator;

/**
 * 検索結果情報.
 * 
 * @version 2014/07/14
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public interface SearchResult extends Iterator<Row> {

	/**
	 * 情報クリア.
	 */
	public void clear();

	/**
	 * テーブル名を取得.
	 * 
	 * @return String テーブル名が返却されます.
	 */
	public String getName();

	/**
	 * テーブルオブジェクトを取得.
	 * 
	 * @return Table テーブルオブジェクトが返却されます.
	 */
	public Table getTable();

	/**
	 * 現在カーソル位置の行情報を取得.
	 * 
	 * @return Row 現在カーソル位置の行情報が返却されます.
	 */
	public Row get();

	/**
	 * 先頭行に移動.
	 * 
	 * @return SearchResult オブジェクトが返却されます.
	 */
	public SearchResult first();

	/**
	 * 最終行に移動.
	 * 
	 * @return SearchResult オブジェクトが返却されます.
	 */
	public SearchResult last();

	/**
	 * 指定行に移動.
	 * 
	 * @param no
	 *            移動先の行を指定します.
	 * @return SearchResult オブジェクトが返却されます.
	 */
	public SearchResult setRow(int no);

	/**
	 * 現在の行番号を取得.
	 * 
	 * @return int 現在の行番号が返却されます.
	 */
	public int getRow();

	/**
	 * 件数を取得.
	 * 
	 * @return int 件数が返却されます.
	 */
	public int getLength();

	/**
	 * 最大件数を取得. ※offset,limitが定義されていない場合は[getLength()]と同様の値が返却されます.
	 * 
	 * @return int 最大件数が返却されます.
	 */
	public int getMax();

}
