package org.maachang.rimdb;

/**
 * 1件のRowデータ.
 * 
 * @version 2014/07/14
 * @author masahito suzuki
 * @since rimdb-1.00
 */
public final class OneSearchResult implements SearchResult {
	private int position = 0;
	private Row row;

	/**
	 * コンストラクタ.
	 * 
	 * @param row
	 *            対象のRowオブジェクトを設定します.
	 */
	public OneSearchResult(Row row) {
		this.row = row;
	}

	/**
	 * 情報クリア.
	 */
	public void clear() {
		row = null;
	}

	/**
	 * テーブル名を取得.
	 * 
	 * @return String テーブル名が返却されます.
	 */
	public String getName() {
		return null;
	}

	/**
	 * テーブルオブジェクトを取得.
	 * 
	 * @return Table テーブルオブジェクトが返却されます.
	 */
	public Table getTable() {
		return null;
	}

	/**
	 * 現在カーソル位置の行情報を取得.
	 * 
	 * @return Row 現在カーソル位置の行情報が返却されます.
	 */
	public Row get() {
		return row;
	}

	/**
	 * 先頭行に移動.
	 * 
	 * @return SearchResult オブジェクトが返却されます.
	 */
	public SearchResult first() {
		position = 0;
		return this;
	}

	/**
	 * 最終行に移動.
	 * 
	 * @return SearchResult オブジェクトが返却されます.
	 */
	public SearchResult last() {
		position = 1;
		return this;
	}

	/**
	 * 指定行に移動.
	 * 
	 * @param no
	 *            移動先の行を指定します.
	 * @return SearchResult オブジェクトが返却されます.
	 */
	public SearchResult setRow(int no) {
		position = no;
		return this;
	}

	/**
	 * 現在の行番号を取得.
	 * 
	 * @return int 現在の行番号が返却されます.
	 */
	public int getRow() {
		return position;
	}

	/**
	 * 件数を取得.
	 * 
	 * @return int 件数が返却されます.
	 */
	public int getLength() {
		return 1;
	}

	/**
	 * 最大件数を取得. ※offset,limitが定義されていない場合は[getLength()]と同様の値が返却されます.
	 * 
	 * @return int 最大件数が返却されます.
	 */
	public int getMax() {
		return 1;
	}

	public final boolean hasNext() {
		if (position == 0 && row != null) {
			return true;
		}
		return false;
	}

	public final Row next() {
		if ((position++) != 0) {
			return null;
		}
		return row;
	}

	public final void remove() {
		return;
	}

}
