package org.maachang.mimdb.jdbc ;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;

import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbStatement;

/**
 * Mimdb-JDBC Statement.
 * 
 * @version 2013/11/19
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public class MimdbJdbcStatement implements java.sql.Statement {
    protected MimdbJdbcConnection base ;
    protected MimdbResult result = null ;
    
    protected MimdbJdbcStatement() {}
    
    protected MimdbJdbcStatement( MimdbJdbcConnection conn ) {
        base = conn ;
    }
    
    public void close() throws SQLException {
        if( base != null ) {
            result = null ;
        }
        base = null ;
    }
    public void addBatch(String sql) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public void cancel() throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public void clearBatch() throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public void clearWarnings() throws SQLException {
    }
    public boolean execute(String sql) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public int[] executeBatch() throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException( "エラー: サポートされていません" ) ;
    }
    
    public ResultSet executeQuery(String sql) throws SQLException {
        try {
            MimdbStatement stmt = MimdbStatement.createStatement( sql ) ;
            MimdbResult res = stmt.executeQuery() ;
            base.statement = stmt ;
            result = res ;
            return new MimdbJdbcResultSet( this ) ;
        } catch( Exception e ) {
            throw new SQLException( e ) ;
        }
    }
    public Connection getConnection() throws SQLException {
        return base ;
    }
    public int getFetchDirection() throws SQLException {
        return ResultSet.FETCH_FORWARD ;
    }
    public int getFetchSize() throws SQLException {
        return 0 ;
    }
    public int getMaxFieldSize() throws SQLException {
        return 0 ;
    }
    public int getMaxRows() throws SQLException {
        return 0 ;
    }
    public boolean getMoreResults() throws SQLException {
        return false ;
    }
    public boolean getMoreResults(int current) throws SQLException {
        return false ;
    }
    public int getQueryTimeout() throws SQLException {
        return 0 ;
    }
    public ResultSet getResultSet() throws SQLException {
        return new MimdbJdbcResultSet( this ) ;
    }
    public int getResultSetConcurrency() throws SQLException {
        return ResultSet.CONCUR_READ_ONLY ;
    }
    public int getResultSetHoldability() throws SQLException {
        return ResultSet.HOLD_CURSORS_OVER_COMMIT ;
    }
    public int getResultSetType() throws SQLException {
        return ResultSet.TYPE_SCROLL_INSENSITIVE  ;
    }
    public int getUpdateCount() throws SQLException {
        return -1 ;
    }
    public SQLWarning getWarnings() throws SQLException {
        return null ;
    }
    public boolean isClosed() throws SQLException {
        return ( base == null ) ;
    }
    public boolean isPoolable() throws SQLException {
        return false ;
    }
    public void setCursorName(String name) throws SQLException {
    }
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }
    public void setFetchDirection(int direction) throws SQLException {
    }
    public void setFetchSize(int rows) throws SQLException {
    }
    public void setMaxFieldSize(int max) throws SQLException {
    }
    public void setMaxRows(int max) throws SQLException {
    }
    public void setPoolable(boolean poolable) throws SQLException {
    }
    public void setQueryTimeout(int seconds) throws SQLException {
    }
    public boolean isWrapperFor(Class<?> iface) {
        return false ;
    }
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null ;
    }
    
    public void closeOnCompletion() throws SQLException {
        // TODO 自動生成されたメソッド・スタブ
        
    }
    
    public boolean isCloseOnCompletion() throws SQLException {
        // TODO 自動生成されたメソッド・スタブ
        return false;
    }
}
