package org.maachang.mimdb.core.impl ;

/**
 * 判別ブロックオブジェクト.
 * 
 * @version 2013/10/27
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public final class WhereBlock {
    private static final int ADD_LEN = 8 ;
    private WhereBlock top = null ;
    private Object[] list = new Object[ ADD_LEN ] ;
    private int length = 0 ;
    
    /** コンストラクタ. **/
    public WhereBlock() {}
    
    /**
     * オブジェクト追加.
     * @param n 対象のオブジェクトを設定します.
     * @return ブロックオブジェクトが返却されます.
     */
    public WhereBlock add( Object n ) {
        if( length + 1 >= list.length ) {
            Object[] tmp = new Object[ length + ADD_LEN ] ;
            System.arraycopy( list,0,tmp,0,length ) ;
            list = tmp ;
        }
        list[ length ++ ] = n ;
        // 追加対象のオブジェクトが別のブロックオブジェクトの場合.
        if( n instanceof WhereBlock ) {
            ((WhereBlock)n).top = this ;
            return (WhereBlock)n ;
        }
        return this ;
    }
    
    /**
     * 上のオブジェクトを取得.
     * @return WhereBlock 上のオブジェクトが返却されます.
     */
    public WhereBlock getTop() {
        return top ;
    }
    
    /**
     * このブロック内に設定されたオブジェクトを取得.
     * @param no 対象の項番を設定します.
     * @return Object オブジェクトが返却されます.
     */
    public Object get( int no ) {
        return list[ no ] ;
    }
    
    /**
     * このブロック内に設定されたオブジェクト数を取得.
     * @return int 設定数が返却されます.
     */
    public int size() {
        return length ;
    }
    
    /**
     * 文字列表示.
     * @return String 文字列として返却されます.
     */
    public String toString() {
        StringBuilder buf = new StringBuilder() ;
        toString( "",buf ) ;
        return buf.toString() ;
    }
    
    private final void toString( String shift,StringBuilder buf ) {
        Object n ;
        for( int i = 0 ; i < length ; i ++ ) {
            n = list[ i ] ;
            if( n instanceof WhereBlock ) {
                ((WhereBlock)n).toString( "  " + shift,buf ) ;
            }
            else {
                buf.append( shift ).append( n ).append( "\n" ) ;
            }
        }
    }
}

