package org.maachang.mimdb.core.impl;

/**
 * NGram検索結果.
 * 
 * @version 2013/10/17
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public interface NGramResult {
    
    /**
     * 次に追加する結果情報を作成.
     * @return NGramResult 次に追加する空の結果情報が返却されます.
     */
    public NGramResult newList() ;
    
    /**
     * 情報を追加.
     * @param p 対象のポジションを設定します.
     * @param o 対象のオフセット値を設定します.
     */
    public void add( int p,int o ) ;
    
    /**
     * 長さを取得.
     * @return int 長さが返却されます.
     */
    public int length() ;
    
    /**
     * ポジションを取得.
     * @param no 対象の項番を設定します.
     * @return int ポジションが返却されます.
     */
    public int position( int no ) ;
    
    /**
     * オフセットを取得.
     * @param no 対象の項番を設定します.
     * @return int オフセットが返却されます.
     */
    public int offset( int no ) ;
    
    /**
     * オフセット値を変更.
     * @param no 対象の項番を設定します.
     * @param newOff 新しいオフセット値を設定します.
     */
    public void offset( int no,int newOff ) ;
    
    /**
     * ポジションをリスト返却
     * @return int[] ポジション情報が返却されます.
     */
    public int[] list() ;
    
}

