package org.maachang.mimdb.core;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

/**
 * 検索結果キャッシュ.
 * 
 * @version 2013/10/11
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
class ResultCache {
    
    /** Result条件. **/
    protected ResultImpl result = new ResultImpl() ;
    
    /** カウント系情報. **/
    protected CountMetaDataImpl countMeta = new CountMetaDataImpl() ;
    protected CountResultRowImpl countRow = new CountResultRowImpl() ;
    
    /** 通常結果系情報. **/
    protected MetaDataImpl meta = new MetaDataImpl() ;
    protected ResultRowImpl row = new ResultRowImpl() ;
    
    /** 結果ポインタ. **/
    protected ResultPointer pointer = new ResultPointer() ;
    
    /** 情報クリア. **/
    protected void clear() {
        countMeta.clear() ;
        countRow.clear() ;
        meta.clear() ;
        row.clear() ;
        pointer.clear() ;
    }
    
    
    
    
    /** キャッシュ保持情報. **/
    protected static final Queue<ResultCache> cache =
        new ConcurrentLinkedQueue<ResultCache>() ;
    
    /** キャッシュ最大保持数. **/
    protected static int maxCache = 9 ;
    
    /** キャッシュ条件をセット. **/
    protected static final void put( ResultCache o ) {
        if( cache.size() >= maxCache ) {
            return ;
        }
        o.clear() ;
        cache.offer( o ) ;
    }
    
    /** キャッシュ情報を取得. **/
    protected static final ResultCache get() {
        if( cache.size() > 0 ) {
            return cache.poll() ;
        }
        return new ResultCache() ;
    }
}
