package org.maachang.mimdb.core ;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 結果カウント要素実装.
 * 
 * @version 2013/10/10
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
@SuppressWarnings("unchecked")
class CountResultRowImpl extends MimdbResultRow {
    
    /** 親オブジェクト. **/
    ResultImpl parent ;
    
    /** カウント数. **/
    int count ;
    
    /**
     * コンストラクタ.
     */
    public CountResultRowImpl() {}
    
    /**
     * コンストラクタ.
     * @param parent 親オブジェクトを設定します.
     * @param count 表示カウントを設定します.
     */
    public CountResultRowImpl( ResultImpl parent,int count ) {
        create( parent,count ) ;
    }
    
    /**
     * 情報生成.
     * @param parent 親オブジェクトを設定します.
     * @param count 表示カウントを設定します.
     */
    public void create( ResultImpl parent,int count ) {
        this.parent = parent ;
        this.count = count ;
    }
    
    /**
     * 情報クリア.
     */
    public void clear() {
        this.parent = null ;
        this.count = 0 ;
    }
    
    /**
     * 更新IDを取得.
     * @return long 更新IDが返却されます.
     */
    public long getDbId() {
        return parent.dbId ;
    }
    
    /**
     * テーブル名の取得.
     * @return String テーブル名が返却されます.
     */
    public String getName() {
        return parent.table.name ;
    }
    
    /**
     * テーブル情報の取得.
     * @return MimdbTable テーブル情報が返却されます.
     */
    public MimdbTable getTable() {
        return parent.table ;
    }
    
    /**
     * 対象の行番号を取得.
     * @return int 行番号が返却されます.
     */
    public int getLineNo() {
        return 0 ;
    }
    
    /**
     * ソート順の取得.
     * @return boolean [true]の場合、降順ソートです.
     */
    public boolean isDesc() {
        return false ;
    }
    
    /**
     * カラム項番で情報を取得.
     * @param n 対象の項番を設定します.
     * @return Object 情報が返却されます.
     */
    public Object getValue( int n ) {
        if( n != 0 ) {
            return null ;
        }
        return count ;
    }
    
    /*********************** 以下 Map定義 ***********************/
    
    public void putAll(Map toMerge) {
        // 処理なし.
    }
    public boolean containsValue(Object value) {
        if( value instanceof Number ) {
            return ( (Number)value ).equals( count ) ;
        }
        return false ;
    }
    public Set entrySet() {
        // 処理なし.
        return null ;
    }
    public Collection values() {
        List<Object> ret = new ArrayList<Object>() ;
        ret.add( count ) ;
        return ret ;
    }
    public Object put(Object name, Object value) {
        // 処理なし.
        return null ;
    }
    public boolean containsKey(Object key) {
        if( key instanceof String ) {
            return CountMetaDataImpl.COLUMN_NAME.equals( key ) ;
        }
        else if( key instanceof Number ) {
            return ((Number)key).intValue() == 0 ;
        }
        return false ;
    }
    public Object get(Object key) {
        if( key instanceof String ) {
            if( CountMetaDataImpl.COLUMN_NAME.equals( key ) ) {
                return count ;
            }
        }
        else if( key instanceof Number ) {
            if( ((Number)key).intValue() == 0 ) {
                return count ;
            }
        }
        return null ;
    }
    public Object remove(Object key) {
        // 処理なし.
        return null ;
    }
    public boolean isEmpty() {
        return false ;
    }
    public Set keySet() {
        Set<Object> ret = new HashSet<Object>() ;
        getAllKey( ret ) ;
        return ret ;
    }
    public int size() {
        return 1 ;
    }
    public void getAllKey( Set<Object> set ) {
        set.add( CountMetaDataImpl.COLUMN_NAME ) ;
    }
    public void getAllValues( Set<Object> set ) {
        set.add( count ) ;
    }
    public String toString() {
        return new StringBuilder( "{" ).append( CountMetaDataImpl.COLUMN_NAME ).
            append( ":" ).append( count ).append( "}" ).toString() ;
    }
}
