package sample ;

import org.maachang.mimdb.Mimdb;
import org.maachang.mimdb.MimdbDatabase;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.core.MimdbResultRow;
import org.maachang.mimdb.core.MimdbStatement;

/**
 * 郵便番号呼び出しサンプル.
 * 
 * @version 2013/11/07
 * @author masahito suzuki
 * @since MasterInMemDB 1.00
 */
public class ReadPostal {
    
    /** mimdbファイル格納先. **/
    private static final String MIMDB_CONF = "/C:/test/mimdbSample/mimdb.conf" ;
    
    /** main. **/
    public static final void main( String[] args ) throws Exception {
        
        MimdbResult rs ;
        MimdbResultRow row ;
        
        // mimdbインスタンスを初期化.
        Mimdb mimdb = Mimdb.getInstance() ;
        mimdb.init( MIMDB_CONF ) ;
        
        // 読み込み完了の場合は、読み込んだテーブル一覧を出力.
        if( mimdb.isInit() ) {
            
            long tm = System.currentTimeMillis() ;
            
            // データベース情報の読み込み.
            // ※必須処理.
            MimdbDatabase db = mimdb.getDatabase( "sample" ) ;
            
            tm = System.currentTimeMillis() - tm ;
            
            // 読み込みテーブル一覧を出力.
            String[] tables = db.getTables() ;
            for( int i = 0 ; i < tables.length ; i ++ ) {
                System.out.println( "(" + (i+1) + ")" + tables[ i ] ) ;
            }
            System.out.println( "\n success..." + tm + "msec" ) ;
            
        }
        
        // 郵便番号.
        // 東京都千代田区=100-0000
        String zip = "1000000" ;
        
        // SQL実行.
        /*
        
        // statemetモード.
        String sql = "select * from postal_master where id='"+zip+"';" ;
        
        MimdbStatement stmt = MimdbStatement.createStatement( sql ) ;
        rs = stmt.executeQuery() ;
        
        // 結果表示.
        while( rs.next() ) {
            row = rs.get() ;
            System.out.println( "結果:" + row ) ;
        }
        */
        
        // Preparedモード.
        String sql = "select * from postal_master where id=? ;" ;
        
        MimdbPreparedStatement ps = MimdbStatement.createPrepared( sql ) ;
        
        // パラメータセット.
        ps.setParams( 0, zip ) ;
        
        // 実行処理.
        rs = ps.executeQuery() ;
        
        // 結果表示.
        while( rs.next() ) {
            row = rs.get() ;
            System.out.println( "結果:" + row ) ;
        }
    }
    
}
