/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.maachang.mimdb.core.MimdbPreparedStatement;
import org.maachang.mimdb.core.MimdbResult;
import org.maachang.mimdb.jdbc.MimdbJdbcConnection;
import org.maachang.mimdb.jdbc.MimdbJdbcParameterMetaData;
import org.maachang.mimdb.jdbc.MimdbJdbcResultSet;
import org.maachang.mimdb.jdbc.MimdbJdbcResultSetMetaData;
import org.maachang.mimdb.jdbc.MimdbJdbcStatement;

public class MimdbJdbcPreparedStatement
extends MimdbJdbcStatement
implements PreparedStatement {
    protected MimdbPreparedStatement pstmt;
    protected String name;

    protected MimdbJdbcPreparedStatement() {
    }

    protected MimdbJdbcPreparedStatement(MimdbJdbcConnection conn, MimdbPreparedStatement p) {
        super(conn);
        this.pstmt = p;
        this.name = p.getName();
    }

    public void close() throws SQLException {
        super.close();
        this.pstmt = null;
    }

    public void addBatch() throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void clearParameters() throws SQLException {
        this.pstmt.clearParams();
    }

    public boolean execute() throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return false;
    }

    public ResultSet executeQuery() throws SQLException {
        try {
            MimdbResult res;
            this.result = res = this.pstmt.executeQuery(false);
            return new MimdbJdbcResultSet(this);
        }
        catch (Exception e) {
            this.errorsql(e);
            return null;
        }
    }

    public int executeUpdate() throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        return -1;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.base == null || this.result == null) {
            return null;
        }
        return new MimdbJdbcResultSetMetaData(this.result);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return new MimdbJdbcParameterMetaData(this.pstmt);
    }

    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.pstmt.setParams(parameterIndex - 1, x);
    }

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.errorsql("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x.toString());
        }
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.pstmt.setParams(parameterIndex - 1, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.pstmt.setParams(parameterIndex - 1, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x);
        }
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            if (cal != null) {
                cal.setTime(x);
                x = new Date(cal.getTime().getTime());
            }
            this.pstmt.setParams(parameterIndex - 1, x);
        }
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.pstmt.setParams(parameterIndex - 1, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.pstmt.setParams(parameterIndex - 1, Float.valueOf(x));
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.pstmt.setParams(parameterIndex - 1, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.pstmt.setParams(parameterIndex - 1, x);
    }

    public void setNString(int parameterIndex, String value) throws SQLException {
        if (value == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, value);
        }
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.pstmt.setParams(parameterIndex - 1, null);
    }

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.pstmt.setParams(parameterIndex - 1, null);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x);
        }
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x);
        }
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x);
        }
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x);
        }
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x);
        }
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x);
        }
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        if (x == null) {
            this.pstmt.setParams(parameterIndex - 1, null);
        } else {
            this.pstmt.setParams(parameterIndex - 1, x.toString());
        }
    }

    private final void errorsql(String msg) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc:" + this.name + " " + msg);
    }

    private final void errorsql(Exception e) throws SQLException {
        throw new SQLException("\u30a8\u30e9\u30fc:" + this.name, e);
    }
}

