/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import org.maachang.mimdb.core.impl.MStringIndexKey;
import org.maachang.mimdb.core.impl.NGramResult;
import org.maachang.mimdb.core.util.NumberList;

final class NGramLineList
implements NGramResult {
    private NumberList mem;
    private int length;

    NGramLineList() {
    }

    NGramLineList(int m) {
        this(true, m);
    }

    NGramLineList(boolean mode, int m) {
        if (mode) {
            NumberList mm = new NumberList(m << 1);
            int i = 0;
            while (i < m) {
                mm.add(i);
                mm.add(0);
                ++i;
            }
            this.mem = mm;
            this.length = m;
        } else {
            this.mem = new NumberList(m >> 2);
            this.length = 0;
        }
    }

    public NGramResult newList() {
        NGramLineList ret = new NGramLineList();
        if (this.length <= 0) {
            ret.mem = null;
            ret.length = 0;
        } else {
            ret.mem = new NumberList(this.length >> 2);
            ret.length = 0;
        }
        return ret;
    }

    public void add(int p, int o) {
        this.mem.add(p);
        this.mem.add(o);
        ++this.length;
    }

    public int length() {
        return this.length;
    }

    public int position(int no) {
        return this.mem.get(no << 1);
    }

    public int offset(int no) {
        return this.mem.get((no << 1) + 1);
    }

    public void offset(int no, int newOff) {
        this.mem.set((no << 1) + 1, newOff);
    }

    public int[] list() {
        int[] ret = new int[this.length];
        int j = 0;
        int i = 0;
        while (i < this.length) {
            ret[i] = this.mem.get(j);
            j += 2;
            ++i;
        }
        return ret;
    }

    protected void endOffset(int off, MStringIndexKey[] src, MStringIndexKey beforeIndexOf) {
        int len = this.length;
        int cnt = 0;
        NumberList tmp = new NumberList(len >> 2);
        if (beforeIndexOf == null) {
            int i = 0;
            int j = 0;
            while (i < len) {
                if (src[this.mem.get((int)j)].length == this.mem.get(j + 1) + off) {
                    tmp.add(this.mem.get(j));
                    tmp.add(this.mem.get(j + 1) + off);
                    ++cnt;
                }
                ++i;
                j += 2;
            }
        } else {
            int bLen = beforeIndexOf.length;
            int i = 0;
            int j = 0;
            while (i < len) {
                MStringIndexKey s = src[this.mem.get(j)];
                if (s.length == this.mem.get(j + 1) + off) {
                    tmp.add(this.mem.get(j));
                    tmp.add(this.mem.get(j + 1) + off);
                    ++cnt;
                } else {
                    int cLen = s.length;
                    int p = this.mem.get(j + 1) - (bLen - 1);
                    while ((p = s.indexOf(beforeIndexOf, p)) != -1) {
                        if (cLen == p + bLen + off) {
                            tmp.add(this.mem.get(j));
                            tmp.add(p + bLen + off);
                            ++cnt;
                            break;
                        }
                        ++p;
                    }
                }
                ++i;
                j += 2;
            }
        }
        this.mem = tmp;
        this.length = cnt;
    }
}

