/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core.impl;

import java.util.Arrays;
import org.maachang.mimdb.core.impl.MStringIndexKey;
import org.maachang.mimdb.core.impl.NGramLineList;
import org.maachang.mimdb.core.impl.NGramResult;
import org.maachang.mimdb.core.util.NumberKeyValue;
import org.maachang.mimdb.core.util.ObjectList;

public class NGram {
    private NGram() {
    }

    public static final Object createIndex(MStringIndexKey[] list) throws Exception {
        NGramWork w;
        int n;
        int j;
        int lenJ;
        int len;
        if (list == null) {
            return null;
        }
        int srcLen = len = list.length;
        NumberKeyValue<NGramWork> work = new NumberKeyValue<NGramWork>(len);
        int i = 0;
        while (i < len) {
            if (list[i] != null && list[i].length() > 0) {
                char[] s = list[i].value;
                lenJ = s.length;
                j = 0;
                while (j < lenJ) {
                    n = s[j] & 0xFFFF;
                    w = (NGramWork)work.get(n);
                    if (w == null) {
                        w = new NGramWork();
                        w.element = n;
                        work.put(n, w);
                    }
                    w.info.add(new NGramInfo(j, j + 1 == lenJ, i));
                    ++j;
                }
            }
            ++i;
        }
        int cnt = 0;
        int allLength = 0;
        len = work.size();
        NumberKeyValue it = work.reset();
        Object[] emList = new NGramElement[len];
        while (it.hasNext()) {
            n = it.next();
            w = (NGramWork)work.get(n);
            ObjectList<NGramInfo> tmp = w.info;
            lenJ = tmp.size();
            Object[] info = new NGramInfo[lenJ];
            j = 0;
            while (j < lenJ) {
                info[j] = tmp.get(j);
                ++j;
            }
            allLength += lenJ;
            Arrays.sort(info);
            NGramElement em = new NGramElement();
            em.element = n;
            em.info = info;
            emList[cnt++] = em;
        }
        Arrays.sort(emList);
        NGramIndex ret = new NGramIndex();
        ret.list = emList;
        ret.srcLength = srcLen;
        ret.src = list;
        ret.allLength = allLength;
        return ret;
    }

    private static final int searchNGramElements(NGramElement[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid].element;
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    private static final int searchNGramInfo(NGramInfo[] a, int key) {
        int low = 0;
        int high = a.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midVal = a[mid].lineNo;
            if (midVal < key) {
                low = mid + 1;
                continue;
            }
            if (midVal > key) {
                high = mid - 1;
                continue;
            }
            while (--mid >= 0 && a[mid].lineNo == key) {
            }
            if (mid < 0) {
                return 0;
            }
            return mid + 1;
        }
        return -1;
    }

    private static final int nextEq(MStringIndexKey[] list, int no, MStringIndexKey value, int off) {
        char[] src = list[no].value;
        char[] chk = value.value;
        int len = chk.length;
        if (src.length < off + len) {
            return -1;
        }
        int i = off + 1;
        int p = 1;
        while (p < len) {
            if (src[i] != chk[p]) break;
            ++i;
            ++p;
        }
        if (p == len) {
            return off;
        }
        return -1;
    }

    private static final int lastEq(MStringIndexKey[] list, int no, MStringIndexKey value, int off) {
        char[] src = list[no].value;
        char[] chk = value.value;
        if (src.length < off + chk.length) {
            return -1;
        }
        int i = off;
        int p = 0;
        int len = chk.length - 1;
        while (p < len) {
            if (src[i] != chk[p]) break;
            ++i;
            ++p;
        }
        if (p == len) {
            return off;
        }
        return -1;
    }

    public static final NGramResult startsWith(Object ngram, MStringIndexKey value) {
        NGramIndex index = (NGramIndex)ngram;
        int p = NGram.searchNGramElements(index.list, value.value[0]);
        if (p == -1) {
            return null;
        }
        NGramLineList res = new NGramLineList(false, index.srcLength);
        NGramInfo[] info = index.list[p].info;
        int len = info.length;
        int strLen = value.length;
        if (strLen == 1) {
            int i = 0;
            while (i < len) {
                if (info[i].position == 0) {
                    res.add(info[i].lineNo, 1);
                }
                ++i;
            }
        } else {
            MStringIndexKey[] src = index.src;
            int i = 0;
            while (i < len) {
                NGramInfo in = info[i];
                if (in.position == 0 && NGram.nextEq(src, in.lineNo, value, 0) == 0) {
                    res.add(in.lineNo, strLen);
                }
                ++i;
            }
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public static final NGramResult endsWith(NGramResult and, Object ngram, MStringIndexKey value) {
        block16: {
            block13: {
                block14: {
                    index = (NGramIndex)ngram;
                    strLen = value.length;
                    p = NGram.searchNGramElements(index.list, value.value[strLen - 1]);
                    if (p == -1) {
                        return null;
                    }
                    strLenM = strLen - 1;
                    info = index.list[p].info;
                    if (and == null) break block13;
                    res = and.newList();
                    len = and.length();
                    src = index.src;
                    if (strLen != 1) break block14;
                    i = 0;
                    while (i < len) {
                        block15: {
                            j = NGram.searchNGramInfo(info, and.position(i));
                            if (j == -1) break block15;
                            lenJ = info.length;
                            n = and.position(i);
                            o = and.offset(i);
                            nowSrc = src[n];
                            if (true) ** GOTO lbl26
                            do {
                                if (in.end && in.position - strLenM >= o && nowSrc.length == o + strLen + 1) {
                                    res.add(in.lineNo, in.position);
                                }
                                ++j;
lbl26:
                                // 2 sources

                                if (j >= lenJ) break;
                                in = info[j];
                            } while (n == in.lineNo);
                        }
                        ++i;
                    }
                    break block16;
                }
                i = 0;
                while (i < len) {
                    block17: {
                        j = NGram.searchNGramInfo(info, and.position(i));
                        if (j == -1) break block17;
                        lenJ = info.length;
                        n = and.position(i);
                        o = and.offset(i);
                        nowSrc = src[n];
                        if (true) ** GOTO lbl47
                        do {
                            if (in.end && in.position - strLenM >= o && nowSrc.length == o + strLen + 1 && NGram.lastEq(src, in.lineNo, value, oLen = in.position - strLenM) == oLen) {
                                res.add(in.lineNo, in.position);
                            }
                            ++j;
lbl47:
                            // 2 sources

                            if (j >= lenJ) break;
                            in = info[j];
                        } while (n == in.lineNo);
                    }
                    ++i;
                }
                break block16;
            }
            res = new NGramLineList(false, index.srcLength);
            len = info.length;
            if (strLen == 1) {
                i = 0;
                while (i < len) {
                    if (info[i].end) {
                        res.add(info[i].lineNo, info[i].position);
                    }
                    ++i;
                }
            } else {
                src = index.src;
                i = 0;
                while (i < len) {
                    in = info[i];
                    if (in.end && NGram.lastEq(src, in.lineNo, value, oLen = in.position - strLenM) == oLen) {
                        res.add(in.lineNo, in.position);
                    }
                    ++i;
                }
            }
        }
        return res;
    }

    /*
     * Unable to fully structure code
     */
    public static final NGramResult indexOf(NGramResult and, Object ngram, MStringIndexKey value) {
        block19: {
            block16: {
                block17: {
                    index = (NGramIndex)ngram;
                    strLen = value.length;
                    p = NGram.searchNGramElements(index.list, value.value[0]);
                    if (p == -1) {
                        return null;
                    }
                    info = index.list[p].info;
                    src = index.src;
                    if (and == null) break block16;
                    res = and.newList();
                    len = and.length();
                    if (strLen != 1) break block17;
                    i = 0;
                    while (i < len) {
                        block18: {
                            j = NGram.searchNGramInfo(info, and.position(i));
                            if (j == -1) break block18;
                            lenJ = info.length;
                            n = and.position(i);
                            o = and.offset(i);
                            if (true) ** GOTO lbl25
                            do {
                                if (in.position >= o) {
                                    res.add(in.lineNo, in.position + strLen);
                                    break;
                                }
                                ++j;
lbl25:
                                // 2 sources

                                if (j >= lenJ) break;
                                in = info[j];
                            } while (n == in.lineNo);
                        }
                        ++i;
                    }
                    break block19;
                }
                i = 0;
                while (i < len) {
                    block20: {
                        j = NGram.searchNGramInfo(info, and.position(i));
                        if (j == -1) break block20;
                        lenJ = info.length;
                        n = and.position(i);
                        o = and.offset(i);
                        if (true) ** GOTO lbl46
                        do {
                            if (in.position >= o && NGram.nextEq(src, n, value, in.position) == in.position) {
                                res.add(in.lineNo, in.position + strLen);
                                break;
                            }
                            ++j;
lbl46:
                            // 2 sources

                            if (j >= lenJ) break;
                            in = info[j];
                        } while (n == in.lineNo);
                    }
                    ++i;
                }
                break block19;
            }
            res = new NGramLineList(false, index.srcLength);
            len = info.length;
            if (strLen == 1) {
                i = 0;
                while (i < len) {
                    j = info[i].lineNo;
                    res.add(info[i].lineNo, info[i].position + strLen);
                    ++i;
                    while (i < len) {
                        if (info[i].lineNo != j) {
                            --i;
                            break;
                        }
                        ++i;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < len) {
                    in = info[i];
                    if (NGram.nextEq(src, in.lineNo, value, in.position) == in.position) {
                        res.add(in.lineNo, in.position + strLen);
                        ++i;
                        while (i < len) {
                            if (info[i].lineNo != in.lineNo) {
                                --i;
                                break;
                            }
                            ++i;
                        }
                    }
                    ++i;
                }
            }
        }
        return res;
    }

    /*
     * Exception decompiling
     */
    public static final NGramResult eqaulsPosition(boolean last, NGramResult and, Object ngram, MStringIndexKey value, int addOff, MStringIndexKey beforeIndexOf) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[DOLOOP]], but top level block is 46[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NGramInfo
    implements Comparable<NGramInfo> {
        int position;
        boolean end;
        int lineNo;

        public NGramInfo(int p, boolean e, int l) {
            this.position = p;
            this.end = e;
            this.lineNo = l;
        }

        @Override
        public int compareTo(NGramInfo n) {
            if (this.lineNo == n.lineNo) {
                return this.position - n.position;
            }
            return this.lineNo - n.lineNo;
        }
    }

    private static final class NGramWork {
        int element;
        ObjectList<NGramInfo> info = new ObjectList();

        NGramWork() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NGramElement
    implements Comparable<NGramElement> {
        int element;
        NGramInfo[] info;

        NGramElement() {
        }

        @Override
        public int compareTo(NGramElement n) {
            return this.element - n.element;
        }
    }

    private static final class NGramIndex {
        NGramElement[] list;
        MStringIndexKey[] src;
        int srcLength;
        int allLength;

        NGramIndex() {
        }
    }
}

