/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb.core;

import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.core.MimdbCsvTable;
import org.maachang.mimdb.core.MimdbJdbcTable;
import org.maachang.mimdb.core.MimdbTableManager;
import org.maachang.mimdb.core.util.Config;

public final class MimdbTableInstance {
    private MimdbTableInstance() {
    }

    public static final String create(String baseFolder, String name) throws Exception {
        return MimdbTableInstance.create(baseFolder, Config.read(name));
    }

    public static final String create(String baseFolder, Config conf) throws Exception {
        if (conf == null || !conf.isSection("mimdb")) {
            throw new MimdbException("\u6307\u5b9aConf\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001mimdb\u5b9a\u7fa9\u3067\u306f\u6709\u308a\u307e\u305b\u3093");
        }
        if (conf.isSection("jdbc")) {
            return MimdbJdbcTable.create(conf);
        }
        if (conf.isSection("csv") && conf.isSection("column")) {
            return MimdbCsvTable.create(baseFolder, conf);
        }
        throw new MimdbException("\u6307\u5b9aConf\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001mimdb\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u3067\u306f\u6709\u308a\u307e\u305b\u3093");
    }

    protected static final long begin(String name) {
        MimdbTableManager m = MimdbTableManager.getInstance();
        m.begin(name, true);
        return m.updateId(name);
    }

    protected static final void end(String name) {
        MimdbTableManager.getInstance().end(name);
    }

    protected static final void errorEnd(String name, long id) {
        MimdbTableManager m = MimdbTableManager.getInstance();
        m.rollbackId(name, id);
        m.end(name);
    }

    protected static final String getTableName(Config conf) throws Exception {
        String tableName = conf.getString("mimdb", "table", 0);
        if (tableName == null || (tableName = tableName.trim()).length() <= 0) {
            throw new MimdbException("\u30c6\u30fc\u30d6\u30eb\u540d\u306f\u5b9a\u7fa9\u3055\u308c\u3066\u307e\u305b\u3093");
        }
        return tableName.toLowerCase();
    }

    protected static final String getPrimaryKey(Config conf) throws Exception {
        String primary = conf.getString("mimdb", "primary", 0);
        if (primary == null || (primary = primary.trim()).length() <= 0) {
            return null;
        }
        return primary.toLowerCase();
    }

    protected static final boolean getCompressFlag(Config conf) throws Exception {
        return conf.getBoolean("mimdb", "compress", 0);
    }

    protected static final int getCompressLength(Config conf) throws Exception {
        return conf.getInt("mimdb", "compressLength", 0);
    }

    protected static final String[] getIndexNames(Config conf) throws Exception {
        int len = conf.size("mimdb", "index");
        if (len <= 0) {
            return null;
        }
        String[] ret = new String[len];
        int i = 0;
        while (i < len) {
            ret[i] = conf.getString("mimdb", "index", i).trim().toLowerCase();
            ++i;
        }
        return ret;
    }

    protected static final String[] getNGramIndexNames(Config conf) throws Exception {
        int len = conf.size("mimdb", "ngram");
        if (len <= 0) {
            return null;
        }
        String[] ret = new String[len];
        int i = 0;
        while (i < len) {
            ret[i] = conf.getString("mimdb", "ngram", i).trim().toLowerCase();
            ++i;
        }
        return ret;
    }
}

