/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.mimdb;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.maachang.mimdb.MimdbDatabase;
import org.maachang.mimdb.MimdbException;
import org.maachang.mimdb.MimdbMaintenanceServer;
import org.maachang.mimdb.core.impl.MimdbUtils;
import org.maachang.mimdb.core.util.AtomicNumber;
import org.maachang.mimdb.core.util.Config;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Mimdb {
    public static final int VERSION_MAJOR = 1;
    public static final int VERSION_MINOR = 0;
    public static final String VERSION = "1.0";
    protected static final Mimdb SNGL = new Mimdb();
    private MimdbMaintenanceServer maintenance = null;
    private final AtomicNumber initFlag = new AtomicNumber(0L);
    protected Map<String, MimdbDatabase> manager = new ConcurrentHashMap<String, MimdbDatabase>();
    protected Map<String, String> aliasNames = new ConcurrentHashMap<String, String>();
    private ReentrantReadWriteLock sync = new ReentrantReadWriteLock();

    private Mimdb() {
    }

    public static final Mimdb getInstance() {
        return SNGL;
    }

    public final void init(String name) throws Exception {
        this.init(Config.read(name));
    }

    public final void init(Config conf) throws Exception {
        long old = -1L;
        this.sync.writeLock().lock();
        try {
            try {
                old = this.initFlag.setToBeforeReturn(1L);
                if (old != 0L) {
                    throw new MimdbException("\u65e2\u306b\u521d\u671f\u51e6\u7406\u306f\u884c\u308f\u308c\u3066\u3044\u307e\u3059");
                }
                if (!conf.isSection("mimdb")) {
                    throw new MimdbException("mimdb\u30bb\u30af\u30b7\u30e7\u30f3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                if (!conf.isSection("maintenance")) {
                    throw new MimdbException("maintenance\u30bb\u30af\u30b7\u30e7\u30f3\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                this.initMimdb(conf);
                this.initMaintenance(conf);
            }
            catch (Exception e) {
                if (old != -1L) {
                    this.initFlag.set(old);
                }
                throw e;
            }
        }
        finally {
            this.sync.writeLock().unlock();
        }
    }

    private final void initMimdb(Config conf) throws Exception {
        String[] keys = conf.getKeys("mimdb");
        if (keys == null || keys.length <= 0) {
            this.aliasNames.clear();
            return;
        }
        int len = keys.length;
        int i = 0;
        while (i < len) {
            keys[i] = keys[i].trim().toLowerCase();
            String s = conf.get("mimdb", keys[i], 0);
            if (s != null && (s = s.trim()).length() > 0) {
                this.aliasNames.put(keys[i], MimdbUtils.getFullPath(s));
            }
            ++i;
        }
    }

    private final void initMaintenance(Config conf) throws Exception {
        if (!conf.getBoolean("maintenance", "mode", 0)) {
            this.maintenance = null;
            return;
        }
        String addr = conf.getString("maintenance", "addr", 0);
        if (addr == null || (addr = addr.trim()).length() <= 0) {
            addr = null;
        }
        this.maintenance = new MimdbMaintenanceServer(this.manager, addr, conf.getInt("maintenance", "port", 0), conf.getInt("maintenance", "backlog", 0));
    }

    private final void check() throws Exception {
        if (this.initFlag.get() != 1L) {
            throw new MimdbException("Mimdb\u521d\u671f\u5316\u51e6\u7406\u304c\u884c\u308f\u308c\u3066\u3044\u307e\u305b\u3093");
        }
    }

    public boolean isInit() {
        return this.initFlag.get() == 1L;
    }

    public boolean isMaintenance() {
        this.sync.readLock().lock();
        try {
            boolean bl = this.maintenance != null;
            return bl;
        }
        finally {
            this.sync.readLock().unlock();
        }
    }

    public boolean isMaintenanceThread() {
        this.sync.readLock().lock();
        try {
            boolean bl = this.maintenance != null && this.maintenance.isStart();
            return bl;
        }
        finally {
            this.sync.readLock().unlock();
        }
    }

    public MimdbDatabase getDatabase(String name) throws Exception {
        MimdbDatabase em;
        block7: {
            this.check();
            String base = name;
            name = name.trim();
            if (this.aliasNames.containsKey(name.toLowerCase())) {
                name = this.aliasNames.get(name.toLowerCase());
            }
            if (!name.toLowerCase().endsWith(".conf")) {
                name = String.valueOf(name) + ".conf";
            }
            if ((em = this.manager.get(name = MimdbUtils.getFullPath(name))) == null) {
                this.sync.writeLock().lock();
                try {
                    em = this.manager.get(name);
                    if (em != null) break block7;
                    if (MimdbDatabase.isUse(name)) {
                        em = new MimdbDatabase(name);
                        this.manager.put(name, em);
                        break block7;
                    }
                    throw new MimdbException("\u6307\u5b9a\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u5b9a\u7fa9\u5148[" + base + "]\u306f\u7121\u52b9\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u3059");
                }
                finally {
                    this.sync.writeLock().unlock();
                }
            }
        }
        return em;
    }

    public Map<String, MimdbDatabase> getManager() throws Exception {
        this.check();
        return this.manager;
    }

    public Map<String, String> getAlias() throws Exception {
        this.check();
        return this.aliasNames;
    }
}

