package hayashi.osm.tracker;
import java.io.*;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;

import javax.xml.parsers.*;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import org.w3c.dom.*;
import org.xml.sax.SAXException;

public class ListUpdateTime {

	/** メイン
	 * 画像ファイルの更新日付リストをCSV形式のファイルとして出力する。
	 * ※ 対象とするファイルは'*.jpg'のみ
	 *
	 * argv[0] = 出力先ファイル
	 * argv[1] = 画像ファイルが格納されているディレクトリ
	 * @throws IOException
	 *
	 */
	public static void main(String[] argv) throws IOException
	{
		File csvfile = new File("list.csv");
		if (argv.length > 0) {
			csvfile = new File(argv[0]);
		}

		File dir = new File(".");
		if (argv.length > 1) {
			dir = new File(argv[1]);
		}

		if (argv.length < 4) {
			System.out.println("> java -jar ListUpdateTime.jar <outputfile> <targetDir> <time base image> <time> <gpx>");
			System.out.println("> java -jar ListUpdateTime.jar list.csv . IMG_01234.JPG 2012-06-15T12:52:22 鎌倉宮_2012-06-15_12-00-16.gpx");

		}

		/**
		 *
			<wpt lat="35.25714922" lon="139.15490497">
				<ele>62.099998474121094</ele>
				<time>2012-06-11T00:44:38Z</time>
				<hdop>0.75</hdop>
				<name><![CDATA[写真]]></name>
				<cmt><![CDATA[精度: 3.0m]]></cmt>
				<link href="2012-06-11_09-44-38.jpg">
					<text>2012-06-11_09-44-38.jpg</text>
				</link>
				<sat>9</sat>
			</wpt>
		 */
		DocumentBuilderFactory factory;
		DocumentBuilder        builder;

		Node gpx;
		File gpxFile = new File(argv[4]);

		String fileName = gpxFile.getName();
		String iStr = fileName.substring(0, fileName.length() - 4);

		File outputFile = new File(iStr +"_.gpx");
		System.out.println(iStr + " => "+ outputFile.getName());

		try {
			factory = DocumentBuilderFactory.newInstance();
			builder = factory.newDocumentBuilder();
			factory.setIgnoringElementContentWhitespace(true);
			factory.setIgnoringComments(true);
			factory.setValidating(true);

			// GPX file --> Node root
			DOMImplementation domImpl = builder.getDOMImplementation();
			document = domImpl.createDocument("", "gpx", null);
			//Element osmnode = document.getDocumentElement();

			/*
			<gpx>
				<trk>
					<name><![CDATA[Tracked with OSMTracker for Android?]]></name>
					<cmt><![CDATA[警告: HDOP values aren't the HDOP as returned by the GPS device. They're approximated from the location accuracy in meters.]]></cmt>
					<trkseg>
						<trkpt lat="35.32123832" lon="139.56965631">
							<ele>47.20000076293945</ele>
							<time>2012-06-15T03:00:29Z</time>
							<hdop>0.5</hdop>
						</trkpt>
					</trkseg>
				</trk>
				<wpt lat="35.2564461" lon="139.15437809">
				</wpt>
			</gpx>
			*/
			Element trk = null;
			gpx    = builder.parse(gpxFile).getFirstChild();
			NodeList nodes = gpx.getChildNodes();
			for (int i=0; i < nodes.getLength(); i++) {
				Node node2 = nodes.item(i);
				if (node2.getNodeName().equals("trk")) {
					trk = (Element) node2;
				}
			}

			if (trk != null) {
				HashMap<Long,Element> map = trkptMap(trk);
				File baseFile = new File(dir, argv[2]);
				Date jptime = new Date(baseFile.lastModified());

				PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(csvfile)));
				String timeStr = argv[3];
				try {
					Date t = dfjp.parse(timeStr);
					long delta = t.getTime() - jptime.getTime();
					System.out.println("時差： "+ (delta / 1000) +"(sec)");
					pw.println("時差： "+ (delta / 1000) +"(sec)");
					ListUpdateTime.proc(dir, csvfile, delta);

					pw.println("\"name\",\"orignal\",\"gpstime\"");
					File[] files = dir.listFiles();
					for (File image : files) {
						String imageName = image.getName();
						if (checkFile(imageName)) {
							Date itime = new Date(image.lastModified());
							Date uktime = new Date(itime.getTime() + delta);
							pw.print("\""+ fileName +"\",");
							pw.print("\""+ dfjp.format(itime) +"\",");
							pw.println("\""+ dfjp.format(uktime) +"\"");

							Element trkpt = trkpt(map, uktime);
							if (trkpt != null) {
								Element wpt = createWptTag(dir, image, uktime.getTime(), trkpt);
								Element temp = getCopy(gpx.getOwnerDocument(), wpt);
								gpx.appendChild(temp);
							}
						}
					}
				}
				catch (ParseException e) {
					System.out.println("'"+ timeStr +"' の書式が違います(yyyy-MM-dd'T'HH:mm:ss)");
				}
				finally {
					pw.close();
				}
			}


			// 出力
			DOMSource source = new DOMSource(gpx);
			FileOutputStream os = new FileOutputStream(outputFile);
			StreamResult result = new StreamResult(os);
			TransformerFactory transFactory = TransformerFactory.newInstance();
			Transformer transformer = transFactory.newTransformer();
			transformer.setOutputProperty(OutputKeys.INDENT, "yes");
			transformer.setOutputProperty(OutputKeys.METHOD, "xml");
			transformer.transform(source, result);
		}
		catch (ParserConfigurationException e) {
			e.printStackTrace();
		}
		catch (SAXException e) {
			e.printStackTrace();
		}
		catch (TransformerConfigurationException e) {
			e.printStackTrace();
		}
		catch (TransformerException e) {
			e.printStackTrace();
		} catch (ParseException e) {
			e.printStackTrace();
		}
		finally {
		}
	}

	static Document document;

	/**
	 * 2012-06-10T05:09:46Z  （日本時間の'2012-06-10T14:09:46'）
	 */
	static SimpleDateFormat dfjp = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
	static SimpleDateFormat dfuk = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'", Locale.UK);

	/*
	<trk>
		<name><![CDATA[Tracked with OSMTracker for Android?]]></name>
		<cmt><![CDATA[警告: HDOP values aren't the HDOP as returned by the GPS device. They're approximated from the location accuracy in meters.]]></cmt>
		<trkseg>
			<trkpt lat="35.32123832" lon="139.56965631">
				<ele>47.20000076293945</ele>
				<time>2012-06-15T03:00:29Z</time>
				<hdop>0.5</hdop>
			</trkpt>
		</trkseg>
	</trk>

	*/
	public static HashMap<Long,Element> trkptMap(Element trk) throws ParseException {
		HashMap<Long,Element> map = new HashMap<Long,Element>();

		NodeList nodes1 = trk.getChildNodes();
		for (int i1=0; i1 < nodes1.getLength(); i1++) {
			Node node2 = nodes1.item(i1);
			if (node2.getNodeName().equals("trkseg")) {
				Element trkseg = (Element) node2;
				NodeList nodes2 = trkseg.getChildNodes();
				for (int i2=0; i2 < nodes2.getLength(); i2++) {
					Node node3 = nodes2.item(i2);
					if (node3.getNodeName().equals("trkpt")) {
						Element trkpt = (Element) node3;

						NodeList nodes3 = trkpt.getChildNodes();
						for (int i3=0; i3 < nodes3.getLength(); i3++) {
							Node node4 = nodes3.item(i3);
							if (node4.getNodeName().equals("time")) {
								Element time = (Element) node4;
								NodeList nodes4 = time.getChildNodes();      // 子ノードを取得
								for (int i4=0; i4< nodes4.getLength(); i4++) {
									Node node5 = nodes4.item(i4);
									if (node5 != null) {
										if (node5.getNodeType() == Node.TEXT_NODE) {
											String timeStr = node5.getNodeValue();
											long t = dfuk.parse(timeStr).getTime() + (9L * 3600000L);
											map.put(new Long(t), getCopy(trk.getOwnerDocument(), trkpt));
										}
								    }
								}
							}
						}
					}
				}
			}
		}
		return map;
	}

	public static Element trkpt(HashMap<Long,Element> map, Date jptime) throws ParseException {
		long sa = 2L * 3600000L;
		long jpt = jptime.getTime();
		Element ret = null;

		Set<Long> keySet = map.keySet();  //すべてのキー値を取得
        Iterator<Long> keyIte = keySet.iterator();
        while (keyIte.hasNext()) {    //ループ。反復子iteratorによる　キー　取得
            Long time = keyIte.next();
            long t = time.longValue();
			if (Math.abs(jpt - t) < sa) {
				sa = Math.abs(jpt - t);
				ret = map.get(time);
			}
        }

        if (sa < (60000L * 10L)) {
    		System.out.println(dfuk.format(jpt) +" ("+ sa +")");
    		return ret;
        }
        return null;
	}

	/**
	 *
			<wpt lat="35.25714922" lon="139.15490497">
				<ele>62.099998474121094</ele>
				<time>2012-06-11T00:44:38Z</time>
				<name><![CDATA[写真]]></name>
				<link href="2012-06-11_09-44-38.jpg">
					<text>2012-06-11_09-44-38.jpg</text>
				</link>
			</wpt>

	 * @param dir
	 * @param csvfile
	 * @param delta
	 * @throws IOException
	 */
	public static void proc (File dir, File csvfile, long delta) throws IOException {
		int counter = 0;
		PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(csvfile)));
		pw.println("\"name\",\"orignal\",\"gpstime\"");

		try {
			File[] files = dir.listFiles();
			for (File iFile : files) {
				String fileName = iFile.getName();
				if (checkFile(fileName)) {
					counter++;
					Date jptime = new Date(iFile.lastModified());
					Date uktime = new Date(jptime.getTime() + delta);
					pw.print("\""+ fileName +"\",");
					pw.print("\""+ dfjp.format(jptime) +"\",");
					pw.println("\""+ dfjp.format(uktime) +"\"");
				}
			}
		}
		finally {
			pw.close();
			System.out.println("Image file count = "+ counter);
		}
		System.out.println("SUCESS 'ListUpdateTime' => '"+ csvfile.getAbsolutePath() +"' !");
	}

	/**
	 * 対象は '*.JPG' のみ対象とする
	 */
	public static boolean checkFile(String name) {
		if (name != null && name.toUpperCase().endsWith(".JPG")) {
			return true;
		}
		return false;
	}

	/**
	 *
			<wpt lat="35.25714922" lon="139.15490497">
				<ele>62.099998474121094</ele>
				<time>2012-06-11T00:44:38Z</time>
				<name><![CDATA[写真]]></name>
				<link href="2012-06-11_09-44-38.jpg">
					<text>2012-06-11_09-44-38.jpg</text>
				</link>
			</wpt>

			<trkpt lat="35.32123832" lon="139.56965631">
				<ele>47.20000076293945</ele>
				<time>2012-06-15T03:00:29Z</time>
			</trkpt>

	 * @param dir
	 * @param csvfile
	 * @param delta
	 * @throws IOException
	 */
	public static Element createWptTag(File dir, File iFile, long timestamp, Element trkpt) {
		Element wpt = document.createElement("wpt");

		NamedNodeMap nodeMap = trkpt.getAttributes();
		if (null != nodeMap) {
			for (int j=0; j < nodeMap.getLength(); j++ ) {
				if (nodeMap.item(j).getNodeName().equals("lat")) {
					String lat = nodeMap.item(j).getNodeValue();
					wpt.setAttribute("lat", lat);
				}
				else if (nodeMap.item(j).getNodeName().equals("lon")) {
					String lon = nodeMap.item(j).getNodeValue();
					wpt.setAttribute("lon", lon);
				}
			}
		}

		NodeList nodes1 = trkpt.getChildNodes();
		for (int i1=0; i1 < nodes1.getLength(); i1++) {
			Node node1 = nodes1.item(i1);
			if (node1.getNodeName().equals("ele")) {
				NodeList nodes2 = node1.getChildNodes();
				for (int i2=0; i2 < nodes2.getLength(); i2++) {
					Node node2 = nodes2.item(i2);
					if (node2 != null) {
						if (node2.getNodeType() == Node.TEXT_NODE) {
							String eleStr = node2.getNodeValue();
							Element eleE = document.createElement("ele");
							eleE.setTextContent(eleStr);
							wpt.appendChild(eleE);
						}
				    }
				}
			}
			else if (node1.getNodeName().equals("time")) {
				NodeList nodes2 = node1.getChildNodes();
				for (int i2=0; i2 < nodes2.getLength(); i2++) {
					Node node2 = nodes2.item(i2);
					if (node2 != null) {
						if (node2.getNodeType() == Node.TEXT_NODE) {
							String timeStr = node2.getNodeValue();
							Element timeE = document.createElement("time");
							timeE.setTextContent(timeStr);
							wpt.appendChild(timeE);
						}
				    }
				}
			}
		}

		Element name = document.createElement("name");
		name.appendChild(document.createCDATASection("写真"));
		wpt.appendChild(name);

		Element link = document.createElement("link");
		link.setAttribute("href", dir.getName() + "/"+ iFile.getName());
		Element text = document.createElement("text");
		text.setTextContent(iFile.getName());
		link.appendChild(text);
		wpt.appendChild(link);

		return wpt;
	}

	public static Element getCopy(Document doc, Node node) {
		Element root = doc.createElement(node.getNodeName());

		NamedNodeMap nodeMap = node.getAttributes();
		if (null != nodeMap) {
			for (int j=0; j < nodeMap.getLength(); j++ ) {
				root.setAttribute(nodeMap.item(j).getNodeName(), nodeMap.item(j).getNodeValue());
			}
		}

		NodeList nodes = node.getChildNodes();
		for (int i=0; i < nodes.getLength(); i++) {
			Node node2 = nodes.item(i);
			if (node2.getNodeType() == Node.ELEMENT_NODE) {
				root.appendChild(getCopy(doc, node2));
			}
			else if (node2.getNodeType() == Node.TEXT_NODE) {
				String str = node2.getNodeValue();
				Text textContents = doc.createTextNode(str);
				root.appendChild(textContents);
			}
			else if (node2.getNodeType() == Node.CDATA_SECTION_NODE) {
				String str = node2.getNodeValue();
				CDATASection cdataSection = doc.createCDATASection(str);
				root.appendChild(cdataSection);
			}
		}

		return root;
	}
}