package com.yuji.ec;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;

public class EverClipSampleActivity extends Activity implements OnClickListener {
	private static final String ACTION_INTERCEPT = "com.adamrocker.android.simeji.ACTION_INTERCEPT";
	private static final String REPLACE_KEY = "replace_key";
	private String mReplaceString;
	private Button mReplaceBtn;
	private Button mCancelBtn;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		Intent it = getIntent();
		String action = it.getAction();
		if (action != null && ACTION_INTERCEPT.equals(action)) {
			/* Simejiďoꂽ */
			mReplaceString = it.getStringExtra(REPLACE_KEY);// u̕擾
			setContentView(R.layout.main);
			mReplaceBtn = (Button) findViewById(R.id.replace_btn);
			mReplaceBtn.setOnClickListener(this);
			mCancelBtn = (Button) findViewById(R.id.cancel_btn);
			mCancelBtn.setOnClickListener(this);
		} else {
			// SimejiȊOďoꂽ
			setContentView(R.layout.main);
		}
	}

	public void onClick(View v) {
		String result = null;
		if (v == mReplaceBtn) {
			result = "You say " + mReplaceString + ", don't you?";
		} else if (v == mCancelBtn) {
			result = mReplaceString;
		}
		replace(result);
	}
	
	/**
	 * ̕u
	 * @param result Replacing string
	 */
	private void replace(String result) {
		Intent data = new Intent();
		data.putExtra(REPLACE_KEY, result);
		setResult(RESULT_OK, data);
		finish();
	}
}
