/*
 * Copyright (C) 2011 Yoshinori Sato <ysato@users.sourceforge.jp>

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#include <config.h>
#include <version.h>

#if !defined(CONFIG_RX600_DEBUG_SDRAM)
	.section	".vector","ax"
	.global	_start
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff

	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff

	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	__ram_vec + (20 * 4)	/* 20 privillege exception */
	.long	0xffffffff
	.long	0xffffffff
	.long	__ram_vec + (23 * 4)	/* 23 illigal instruction */

	.long	0xffffffff
	.long	__ram_vec + (25 * 4)	/* 25: floating point exception */
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	0xffffffff
	.long	__ram_vec + (30 * 4)	/* 30: nmi */
	.long	_start
#endif

	.text
	.align	2
_start:
	mov.l	#__stack, r0
	bsr	lowlevel_init

#if !defined(CONFIG_RX600_DEBUG_SDRAM)
	mov.l	#_fdata,r1
	mov.l	#_edata,r3
	sub	r1,r3
	mov.l	#_etext,r2
	smovf
#endif	
	mov.l	#0,r1
	bsr	board_init_f
	
	bra	.

	.global	relocate_code
relocate_code:
	mov.l	r2,r1
	mov.l	r3,r2
	bra	board_init_r

	.end

