-- ${logicalName}
DROP TABLE IF EXISTS `${physicalName}`;

CREATE TABLE `${physicalName}` (
[#list columns as x]
	`${x.physicalName}` ${x.type}[#if generatedValue] AUTO_INCREMENT[#/if][#if notNull] NOT NULL[#/if][#if defaultValue??] DEFAULT ${defaultValue}[#/if][#if logicalName??] COMMENT '${x.logicalName}'[#/if][#if x_index == columns.size - 1 && !hasAudit && primaryKeys.size + indexes.size > 0],[#/if]
[#/list]
[#if hasAudit]
	`delete_flg` CHAR(1) NOT NULL COMMENT '削除フラグ',
	`create_datetime` DATETIME NOT NULL DEFAULT 0 COMMENT '作成日時',
	`create_id` BIGINT NOT NULL COMMENT '作成者ID',
	`update_datetime` DATETIME NOT NULL DEFAULT 0 COMMENT '更新日時',
	`update_id` BIGINT NOT NULL COMMENT '更新者ID'[#if primaryKeys.size + indexes.size > 0],[#/if]
[#/if]
[#if primaryKeys.size > 0]
	PRIMARY KEY ([#list primaryKeys as pk][#if pk_index > 0], [#/if]`${pk.physicalName}`[#/list])[#if indexes.size > 0],[#/if]
[#/if]
[#if indexes.size > 0]
	KEY ([#list indexes as ix][#if ix_index > 0], [#/if]`${ix.physicalName}`[#/list])
[#/if]
)[#list parameters?keys as key] ${key}=${parameters[key]}[#/list][#if logicalName??] COMMENT='${logicalName}'[#/if];
