package net.waltzstudio.montecarlo.dto;

import java.io.Serializable;
import java.util.List;
import net.arnx.jsonic.JSON;
import net.waltzstudio.montecarlo.entity.label.Label;
import net.waltzstudio.montecarlo.entity.project.Project;
import org.seasar.framework.container.annotation.tiger.Component;
import org.seasar.framework.container.annotation.tiger.InstanceType;

/**
 * リクエスト情報Dto
 */
@Component(instance = InstanceType.REQUEST)
public class RequestInfoDto implements Serializable {
	private static final long serialVersionUID = 1L;
	/** プロジェクト識別子 */
	public String projectCode;
	/** プロジェクトID */
	public Long projectId;
	/** プロジェクト名 */
	public String projectName;
	/** プロジェクトリスト */
	public List<Project> projects;
	/** ラベルリスト */
	public List<Label> labels;

	@Override
	public String toString() {
		return JSON.encode(this);
	}

}
