package net.waltzstudio.montecarlo.action;

import javax.annotation.Resource;
import org.seasar.framework.log.Logger;
import org.seasar.struts.annotation.Execute;
import net.waltzstudio.montecarlo.object.Global;
import net.waltzstudio.montecarlo.service.batch.BatchControlService;

/**
 * バッチ管理Action
 */
public class BatchAction {
	/** logger */
	protected Logger logger = Logger.getLogger(BatchAction.class);

	/** バッチ管理Service */
	@Resource
	protected BatchControlService batchControlService;

	/** コマンド */
	public String command;

	/**
	 * index
	 */
	@Execute(validator = false)
	public String index() {
		return "/?redirect=true";
	}

	/**
	 * メール送信デーモン管理
	 */
	@Execute(validator = false, urlPattern = "maild/{command}")
	public String maild() {
		if ("start".equals(command)) {
			batchControlService.start(Global.BatchInfo.SENDMAIL_DAEMON);
		} else if ("stop".equals(command)) {
			batchControlService.stop(Global.BatchInfo.SENDMAIL_DAEMON);
		}
		return "/?redirect=true";
	}

	/**
	 * メール送信バッチ管理
	 */
	@Execute(validator = false, urlPattern = "mail/{command}")
	public String mail() {
		if ("start".equals(command)) {
			batchControlService.start(Global.BatchInfo.SENDMAIL_BATCH);
		} else if ("stop".equals(command)) {
			batchControlService.stop(Global.BatchInfo.SENDMAIL_BATCH);
		}
		return "/?redirect=true";
	}

}
