package net.waltzstudio.montecarlo.types;

/**
 * バッチステータス
 */
public enum BatchStatus {

	/**
	 * 論理名：待機中<br />
	 * 物理名：Standby<br />
	 * 値　　：0<br />
	 */
	STANDBY("待機中", "Standby", "0"),

	/**
	 * 論理名：実行中<br />
	 * 物理名：Active<br />
	 * 値　　：1<br />
	 */
	ACTIVE("実行中", "Active", "1");

	private final String label;
	private final String state;
	private final String value;

	private BatchStatus(String label, String state, String value) {
		this.label = label;
		this.state = state;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}
	public String getState() {
		return state;
	}
	public String getValue() {
		return value;
	}

	public static String convert(BatchStatus value) {
		return value.value;
	}
	public static BatchStatus convert(String value) {
		return create(value);
	}

	public static BatchStatus create(Object value) {
		if (value == null) {
			return null;
		}
		if (value instanceof BatchStatus) {
			return (BatchStatus) value;
		}
		String key = value.toString();
		for (BatchStatus e : values()) {
			if (e.value.equals(key) || e.state.equals(key)) {
				return e;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return value;
	}

}
