package net.waltzstudio.montecarlo.types;

/**
 * 管理者フラグ
 */
public enum AdminFlg {

	/**
	 * 論理名：一般<br />
	 * 物理名：General<br />
	 * 値　　：0<br />
	 */
	GENERAL("新規", "General", "0"),

	/**
	 * 論理名：管理者<br />
	 * 物理名：Admin<br />
	 * 値　　：1<br />
	 */
	ADMIN("管理者", "Admin", "1");

	private final String label;
	private final String state;
	private final String value;

	private AdminFlg(String label, String state, String value) {
		this.label = label;
		this.state = state;
		this.value = value;
	}

	public String getLabel() {
		return label;
	}
	public String getState() {
		return state;
	}
	public String getValue() {
		return value;
	}

	public static String convert(AdminFlg value) {
		return value.value;
	}
	public static AdminFlg convert(String value) {
		return create(value);
	}

	public static AdminFlg create(Object value) {
		if (value == null) {
			return null;
		}
		if (value instanceof AdminFlg) {
			return (AdminFlg) value;
		}
		String key = value.toString();
		for (AdminFlg e : values()) {
			if (e.value.equals(key) || e.state.equals(key)) {
				return e;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		return value;
	}

}
