package net.waltzstudio.montecarlo.entity.ticket;

import java.util.Date;
import org.seasar.extension.jdbc.name.PropertyName;
import net.waltzstudio.base.framework.entity.AuditEntityName;
import net.waltzstudio.montecarlo.types.TicketStatus;

/**
 * チケットEntityName
 */
public interface TicketName extends AuditEntityName {

	/** ID */
	public static PropertyName<Long> $ID = new PropertyName<Long>("id");

	/** プロジェクトID */
	public static PropertyName<Long> $PROJECT_ID = new PropertyName<Long>("projectId");

	/** パス */
	public static PropertyName<String> $PATH = new PropertyName<String>("path");

	/** ステータス */
	public static PropertyName<TicketStatus> $STATUS = new PropertyName<TicketStatus>("status");

	/** 開始日 */
	public static PropertyName<Date> $FROM_DATE = new PropertyName<Date>("fromDate");

	/** 終了日 */
	public static PropertyName<Date> $TO_DATE = new PropertyName<Date>("toDate");

	/** タイトル */
	public static PropertyName<String> $TITLE = new PropertyName<String>("title");

	/** 内容 */
	public static PropertyName<String> $DESCRIPTION = new PropertyName<String>("description");

	/** 登録者ID */
	public static PropertyName<Long> $REGISTER_ID = new PropertyName<Long>("registerId");

	/** 担当者ID */
	public static PropertyName<Long> $ASSIGNED_ID = new PropertyName<Long>("assignedId");

	/** 更新日時 */
	public static PropertyName<Date> $MODIFY_DATE = new PropertyName<Date>("modifyDate");

}
