package net.waltzstudio.montecarlo.dao.ticket;

import static org.seasar.extension.jdbc.operation.Operations.*;
import java.util.List;
import net.waltzstudio.base.framework.dao.AuditDao;
import net.waltzstudio.base.framework.types.DeleteFlg;
import net.waltzstudio.montecarlo.entity.ticket.Ticket;
import net.waltzstudio.montecarlo.entity.ticket.TicketName;

/**
 * チケットDaoBase
 */
public abstract class TicketDaoBase extends AuditDao<Ticket> implements TicketName {

	public Ticket findById(Long id) {
		return select().id(id).where(eq($DELETE_FLG, DeleteFlg.NORMAL)).getSingleResult();
	}

	public List<Ticket> findAllOrderById() {
		return select().where(eq($DELETE_FLG, DeleteFlg.NORMAL)).orderBy(asc($ID)).getResultList();
	}

}
