package net.waltzstudio.montecarlo.dao.accountProject;

import static org.seasar.extension.jdbc.operation.Operations.*;
import java.util.List;
import net.waltzstudio.base.framework.dao.AuditDao;
import net.waltzstudio.base.framework.types.DeleteFlg;
import net.waltzstudio.montecarlo.entity.accountProject.AccountProject;
import net.waltzstudio.montecarlo.entity.accountProject.AccountProjectName;

/**
 * アカウント・プロジェクト紐付けDaoBase
 */
public abstract class AccountProjectDaoBase extends AuditDao<AccountProject> implements AccountProjectName {

	public AccountProject findById(Long id) {
		return select().id(id).where(eq($DELETE_FLG, DeleteFlg.NORMAL)).getSingleResult();
	}

	public List<AccountProject> findAllOrderById() {
		return select().where(eq($DELETE_FLG, DeleteFlg.NORMAL)).orderBy(asc($ID)).getResultList();
	}

}
