/*
 * Decompiled with CFR 0.152.
 */
package net.arnx.jsonic;

import java.util.Iterator;
import net.arnx.jsonic.Formatter;
import net.arnx.jsonic.JSON;
import net.arnx.jsonic.JSONHint;
import net.arnx.jsonic.NullFormatter;
import net.arnx.jsonic.io.OutputSource;

final class IteratorFormatter
implements Formatter {
    public static final IteratorFormatter INSTANCE = new IteratorFormatter();

    IteratorFormatter() {
    }

    public boolean format(JSON json, JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        Iterator t = (Iterator)o;
        JSONHint hint = context.getHint();
        Class<?> lastClass = null;
        Formatter lastFormatter = null;
        out.append('[');
        int count = 0;
        while (t.hasNext()) {
            Object item = t.next();
            if (item == src) {
                item = null;
            }
            if (count != 0) {
                out.append(',');
            }
            if (context.isPrettyPrint()) {
                out.append('\n');
                for (int j = 0; j < context.getDepth() + 1; ++j) {
                    out.append('\t');
                }
            }
            context.enter(count, hint);
            item = json.preformatInternal(context, item);
            if (item == null) {
                NullFormatter.INSTANCE.format(json, context, src, item, out);
            } else if (hint == null) {
                if (item.getClass().equals(lastClass)) {
                    lastFormatter.format(json, context, src, item, out);
                } else {
                    lastFormatter = json.formatInternal(context, item, out);
                    lastClass = item.getClass();
                }
            } else {
                json.formatInternal(context, item, out);
            }
            context.exit();
            ++count;
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            for (int j = 0; j < context.getDepth(); ++j) {
                out.append('\t');
            }
        }
        out.append(']');
        return true;
    }
}

