/*
 * Decompiled with CFR 0.152.
 */
package org.h2.tools;

import java.sql.SQLException;
import java.util.ArrayList;
import org.h2.store.FileLister;
import org.h2.util.FileUtils;
import org.h2.util.Tool;

public class DeleteDbFiles
extends Tool {
    private void showUsage() {
        this.out.println("Deletes all files belonging to a database.");
        this.out.println("java " + this.getClass().getName() + "\n" + " [-dir <dir>]      The directory (default: .)\n" + " [-db <database>]  The database name\n" + " [-quiet]          Do not print progress information");
        this.out.println("See also http://h2database.com/javadoc/" + this.getClass().getName().replace('.', '/') + ".html");
    }

    public static void main(String[] args) throws SQLException {
        new DeleteDbFiles().run(args);
    }

    public void run(String[] args) throws SQLException {
        String dir = ".";
        String db = null;
        boolean quiet = false;
        for (int i = 0; args != null && i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-dir")) {
                dir = args[++i];
                continue;
            }
            if (arg.equals("-db")) {
                db = args[++i];
                continue;
            }
            if (arg.equals("-quiet")) {
                quiet = true;
                continue;
            }
            if (arg.equals("-help") || arg.equals("-?")) {
                this.showUsage();
                return;
            }
            this.out.println("Unsupported option: " + arg);
            this.showUsage();
            return;
        }
        this.process(dir, db, quiet);
    }

    public static void execute(String dir, String db, boolean quiet) throws SQLException {
        new DeleteDbFiles().process(dir, db, quiet);
    }

    private void process(String dir, String db, boolean quiet) throws SQLException {
        DeleteDbFiles delete = new DeleteDbFiles();
        ArrayList files = FileLister.getDatabaseFiles(dir, db, true);
        for (int i = 0; i < files.size(); ++i) {
            String fileName = (String)files.get(i);
            delete.process(fileName, quiet);
            if (quiet) continue;
            this.out.println("Processed: " + fileName);
        }
        if (files.size() == 0 && !quiet) {
            this.out.println("No database files found");
        }
    }

    private void process(String fileName, boolean quiet) throws SQLException {
        if (quiet || fileName.endsWith(".temp.db") || fileName.endsWith(".trace.db")) {
            FileUtils.tryDelete(fileName);
        } else {
            FileUtils.delete(fileName);
        }
    }
}

