package jp.gr.java_conf.wutse.purewiki.syntax.line;

import jp.gr.java_conf.wutse.purewiki.PureWikiContext;
import jp.gr.java_conf.wutse.purewiki.syntax.LineSyntax;
import jp.gr.java_conf.wutse.purewiki.util.PureWikiUtil;

public class BrSyntax implements LineSyntax {
	@Override
	public boolean condition(PureWikiContext context) {
		String line = context.getLine();
		return PureWikiUtil.isBlank(line);
	}

	@Override
	public String begin(PureWikiContext context) {
		return "<P>";
	}

	@Override
	public String line(PureWikiContext context) {
		if (!condition(context)) {
			return context.getLine() + "<BR>\n";
		}
		return "<BR>\n";
	}

	@Override
	public String end(PureWikiContext context) {
		return "</P>";
	}
}
